<%
/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
%> 
<%@include file="../init.jsp" %>

<%@ page import="org.xmlportletfactory.xmlpf.calculated.model.Calculated" %>
<%@ page import="org.xmlportletfactory.xmlpf.calculated.service.CalculatedLocalServiceUtil" %>

<%@ page import="com.liferay.portlet.PortalPreferences" %>
<%@ page import="com.liferay.portal.kernel.util.Validator" %>
<%@ page import="com.liferay.portal.kernel.util.OrderByComparator" %>
<%@ page import="org.xmlportletfactory.xmlpf.calculated.CalculatedComparator" %>

<%@ page import="javax.script.ScriptEngine" %>
<%@ page import="javax.script.ScriptEngineManager" %>


<jsp:useBean id="addCalculatedURL" class="java.lang.String" scope="request" />
<jsp:useBean id="CalculatedFilterURL" class="java.lang.String" scope="request" />
<jsp:useBean id="CalculatedFilter" class="java.lang.String" scope="request" />
<liferay-ui:success key="prefs-success" message="prefs-success" />
<liferay-ui:success key="calculated-added-successfully" message="calculated-added-successfully" />
<liferay-ui:success key="calculated-deleted-successfully" message="calculated-deleted-successfully" />
<liferay-ui:success key="calculated-updated-successfully" message="calculated-updated-successfully" />
<liferay-ui:error key="calculated-error-deleting" message="calculated-error-deleting" />

<c:choose>
	<c:when test='<%= (Boolean)request.getAttribute("hasAddPermission") %>'>
		<aui:button name="addCalculatedButton" href="<%=addCalculatedURL %>" value="calculated-add" />
	</c:when>
</c:choose>

<c:choose>
	<c:when test='<%= (Boolean)request.getAttribute("hasModelPermissions") %>'>
		<liferay-security:permissionsURL
			modelResource="org.xmlportletfactory.xmlpf.calculated.Calculated"
			modelResourceDescription="<%= HtmlUtil.escape(themeDisplay.getScopeGroupName()) %>"
			resourcePrimKey="<%= String.valueOf(themeDisplay.getScopeGroupId()) %>"
			var="modelPermissionsURL"
		/>
		<aui:button href="<%= modelPermissionsURL %>" value="permissions" />
	</c:when>
</c:choose>


<form id="CalculatedFilterForm" name="CalculatedFilterForm" action="<%=CalculatedFilterURL %>" method="POST">
	<input type="text" name="CalculatedFilter" value="<%= CalculatedFilter %>" />
	<input type="submit" value="<liferay-ui:message key="filter" />">
</form>
<%
	String iconChecked = "checked";
	String iconUnchecked = "unchecked";
	int rows_per_page = Integer.parseInt((String)request.getAttribute("rowsPerPage"));

	SimpleDateFormat dateFormat = new SimpleDateFormat(prefs.getValue("date-format", "yyyy/MM/dd"));
	SimpleDateFormat dateTimeFormat = new SimpleDateFormat(prefs.getValue("datetime-format","yyyy/MM/dd HH:mm"));

	PortalPreferences portalPrefs = PortletPreferencesFactoryUtil.getPortalPreferences(request);

	String orderByCol = ParamUtil.getString(request, "orderByCol");
	String orderByType = ParamUtil.getString(request, "orderByType");

	if (Validator.isNotNull(orderByCol) && Validator.isNotNull(orderByType)) {
		portalPrefs.setValue("Calculated_order", "Calculated-order-by-col", orderByCol);
		portalPrefs.setValue("Calculated_order", "Calculated-order-by-type", orderByType);
	} else {
		orderByCol = portalPrefs.getValue("Calculated_order", "Calculated-order-by-col", "calculatedId");
		orderByType = portalPrefs.getValue("Calculated_order", "Calculated-order-by-type", "asc");
	}

	List<Calculated> tempResults = (List<Calculated>)request.getAttribute("tempResults");
	Integer totalCount = (Integer)request.getAttribute("totalCount");

	int containerStart;
	int containerEnd;
	try {
		containerStart = ParamUtil.getInteger(request, "containerStart");
		containerEnd = ParamUtil.getInteger(request, "containerEnd");
	} catch (Exception e) {
		containerStart = 0;
		containerEnd = rows_per_page;
	}

%>
<liferay-ui:search-container deltaConfigurable="false" delta='<%= rows_per_page %>' emptyResultsMessage="calculated-empty-results-message" orderByCol="<%= orderByCol%>" orderByType="<%= orderByType%>">
	<liferay-ui:search-container-results total="<%= totalCount %>" results="<%= tempResults %>">

		<%
		request.setAttribute("containerStart",String.valueOf(containerStart));
		request.setAttribute("containerEnd",String.valueOf(containerEnd));
		request.setAttribute("orderByCol", orderByCol);
		request.setAttribute("orderByType", orderByType);
		%>

	</liferay-ui:search-container-results>

	<liferay-ui:search-container-row
		className="org.xmlportletfactory.xmlpf.calculated.model.Calculated"
		keyProperty="calculatedId"
		modelVar="calculated"
	>

		<liferay-ui:search-container-column-text
			name="Name"
		    property="calculatedName"
			orderable="true"
			orderableProperty="calculatedName"
			align="left"
		/>
		<liferay-ui:search-container-column-text
			name="Price"
		    property="price"
			align="right"
		/>
		<liferay-ui:search-container-column-text
			name="Discount percentage"
		    property="percentDiscount"
			align="right"
		/>
		<liferay-ui:search-container-column-text
			name="VAT percentage"
		    property="percentVAT"
			align="right"
		/>
		<%	
			String calculatedTotalIncoming = "(price-(price*(percentDiscount/100)))+(price*(percentVAT/100))";
			
			String calculatedTotalDelims = "(?<=op)|(?=op)".replace("op", "[-+*/()]");
			
			String[] calculatedTotalTokens = calculatedTotalIncoming.split(calculatedTotalDelims);
			
			StringBuilder calculatedTotalSB = new StringBuilder();

			for (int i = 0; i < calculatedTotalTokens.length; i++) {
				 if ( calculatedTotalTokens[i].toString().equals("price") ) {
	            	calculatedTotalSB.append(String.valueOf(calculated.getPrice()));
	            }
				else if ( calculatedTotalTokens[i].toString().equals("percentDiscount") ) {
	            	calculatedTotalSB.append(String.valueOf(calculated.getPercentDiscount()));
	            }
				else if ( calculatedTotalTokens[i].toString().equals("percentVAT") ) {
	            	calculatedTotalSB.append(String.valueOf(calculated.getPercentVAT()));
	            }
	            else {
	            	calculatedTotalSB.append(calculatedTotalTokens[i].toString());
	            }
	        } 		
			
			ScriptEngineManager calculatedTotalMgr = new ScriptEngineManager();
        	ScriptEngine calculatedTotalEngine = calculatedTotalMgr.getEngineByName("JavaScript");
        	String calculatedTotal = calculatedTotalEngine.eval(calculatedTotalSB.toString()).toString();
		%>
		<liferay-ui:search-container-column-text
			name="Total" 
			align="left"
			value="<%=calculatedTotal%>"
		/>
		<liferay-ui:search-container-column-jsp
			align="right"
			path="/JSPs/Calculated/edit_actions.jsp"
		/>

	</liferay-ui:search-container-row>

	<liferay-ui:search-iterator />

</liferay-ui:search-container>
