/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import org.xmlportletfactory.xmlpf.calculated.service.CalculatedLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Proxy;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Jack A. Rider
 */
public class CalculatedClp extends BaseModelImpl<Calculated>
	implements Calculated {
	public CalculatedClp() {
	}

	public Class<?> getModelClass() {
		return Calculated.class;
	}

	public String getModelClassName() {
		return Calculated.class.getName();
	}

	public long getPrimaryKey() {
		return _calculatedId;
	}

	public void setPrimaryKey(long primaryKey) {
		setCalculatedId(primaryKey);
	}

	public Serializable getPrimaryKeyObj() {
		return new Long(_calculatedId);
	}

	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("calculatedId", getCalculatedId());
		attributes.put("companyId", getCompanyId());
		attributes.put("groupId", getGroupId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("calculatedName", getCalculatedName());
		attributes.put("price", getPrice());
		attributes.put("percentDiscount", getPercentDiscount());
		attributes.put("percentVAT", getPercentVAT());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long calculatedId = (Long)attributes.get("calculatedId");

		if (calculatedId != null) {
			setCalculatedId(calculatedId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String calculatedName = (String)attributes.get("calculatedName");

		if (calculatedName != null) {
			setCalculatedName(calculatedName);
		}

		Double price = (Double)attributes.get("price");

		if (price != null) {
			setPrice(price);
		}

		Double percentDiscount = (Double)attributes.get("percentDiscount");

		if (percentDiscount != null) {
			setPercentDiscount(percentDiscount);
		}

		Double percentVAT = (Double)attributes.get("percentVAT");

		if (percentVAT != null) {
			setPercentVAT(percentVAT);
		}
	}

	public long getCalculatedId() {
		return _calculatedId;
	}

	public void setCalculatedId(long calculatedId) {
		_calculatedId = calculatedId;
	}

	public long getCompanyId() {
		return _companyId;
	}

	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	public long getGroupId() {
		return _groupId;
	}

	public void setGroupId(long groupId) {
		_groupId = groupId;
	}

	public long getUserId() {
		return _userId;
	}

	public void setUserId(long userId) {
		_userId = userId;
	}

	public String getUserUuid() throws SystemException {
		return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
	}

	public void setUserUuid(String userUuid) {
		_userUuid = userUuid;
	}

	public String getUserName() {
		return _userName;
	}

	public void setUserName(String userName) {
		_userName = userName;
	}

	public Date getCreateDate() {
		return _createDate;
	}

	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		_modifiedDate = modifiedDate;
	}

	public String getCalculatedName() {
		return _calculatedName;
	}

	public void setCalculatedName(String calculatedName) {
		_calculatedName = calculatedName;
	}

	public double getPrice() {
		return _price;
	}

	public void setPrice(double price) {
		_price = price;
	}

	public double getPercentDiscount() {
		return _percentDiscount;
	}

	public void setPercentDiscount(double percentDiscount) {
		_percentDiscount = percentDiscount;
	}

	public double getPercentVAT() {
		return _percentVAT;
	}

	public void setPercentVAT(double percentVAT) {
		_percentVAT = percentVAT;
	}

	public BaseModel<?> getCalculatedRemoteModel() {
		return _calculatedRemoteModel;
	}

	public void setCalculatedRemoteModel(BaseModel<?> calculatedRemoteModel) {
		_calculatedRemoteModel = calculatedRemoteModel;
	}

	public void persist() throws SystemException {
		if (this.isNew()) {
			CalculatedLocalServiceUtil.addCalculated(this);
		}
		else {
			CalculatedLocalServiceUtil.updateCalculated(this);
		}
	}

	@Override
	public Calculated toEscapedModel() {
		return (Calculated)Proxy.newProxyInstance(Calculated.class.getClassLoader(),
			new Class[] { Calculated.class }, new AutoEscapeBeanHandler(this));
	}

	@Override
	public Object clone() {
		CalculatedClp clone = new CalculatedClp();

		clone.setCalculatedId(getCalculatedId());
		clone.setCompanyId(getCompanyId());
		clone.setGroupId(getGroupId());
		clone.setUserId(getUserId());
		clone.setUserName(getUserName());
		clone.setCreateDate(getCreateDate());
		clone.setModifiedDate(getModifiedDate());
		clone.setCalculatedName(getCalculatedName());
		clone.setPrice(getPrice());
		clone.setPercentDiscount(getPercentDiscount());
		clone.setPercentVAT(getPercentVAT());

		return clone;
	}

	public int compareTo(Calculated calculated) {
		long primaryKey = calculated.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}

		CalculatedClp calculated = null;

		try {
			calculated = (CalculatedClp)obj;
		}
		catch (ClassCastException cce) {
			return false;
		}

		long primaryKey = calculated.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(23);

		sb.append("{calculatedId=");
		sb.append(getCalculatedId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", calculatedName=");
		sb.append(getCalculatedName());
		sb.append(", price=");
		sb.append(getPrice());
		sb.append(", percentDiscount=");
		sb.append(getPercentDiscount());
		sb.append(", percentVAT=");
		sb.append(getPercentVAT());
		sb.append("}");

		return sb.toString();
	}

	public String toXmlString() {
		StringBundler sb = new StringBundler(37);

		sb.append("<model><model-name>");
		sb.append("org.xmlportletfactory.xmlpf.calculated.model.Calculated");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>calculatedId</column-name><column-value><![CDATA[");
		sb.append(getCalculatedId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>calculatedName</column-name><column-value><![CDATA[");
		sb.append(getCalculatedName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>price</column-name><column-value><![CDATA[");
		sb.append(getPrice());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>percentDiscount</column-name><column-value><![CDATA[");
		sb.append(getPercentDiscount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>percentVAT</column-name><column-value><![CDATA[");
		sb.append(getPercentVAT());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private long _calculatedId;
	private long _companyId;
	private long _groupId;
	private long _userId;
	private String _userUuid;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private String _calculatedName;
	private double _price;
	private double _percentDiscount;
	private double _percentVAT;
	private BaseModel<?> _calculatedRemoteModel;
}