/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
 
 
package org.xmlportletfactory.xmlpf.calculated;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletURL;
import javax.portlet.ProcessAction;
import javax.portlet.ProcessEvent;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletConfig;
import javax.xml.namespace.QName;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.poi.ss.usermodel.Workbook;
import com.liferay.portal.kernel.servlet.HttpHeaders;

import com.liferay.portal.kernel.dao.search.SearchContainer;

import org.xmlportletfactory.xmlpf.calculated.model.Calculated;
import org.xmlportletfactory.xmlpf.calculated.model.impl.CalculatedImpl;
import org.xmlportletfactory.xmlpf.calculated.service.CalculatedLocalServiceUtil;
import org.xmlportletfactory.xmlpf.calculated.service.permission.CalculatedPermission;
import org.xmlportletfactory.xmlpf.calculated.service.permission.CalculatedEntryPermission;


import org.xmlportletfactory.xmlpf.calculated.util.CalculatedUtil;

import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.util.JavaConstants;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ActionKeys;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;

/**
 * Portlet implementation class Calculated
 */
public class CalculatedPortlet extends MVCPortlet {



	public void init() throws PortletException {

		// Edit Mode Pages
		editJSP = getInitParameter("edit-jsp");

		// Help Mode Pages
		helpJSP = getInitParameter("help-jsp");

		// View Mode Pages
		viewJSP = getInitParameter("view-jsp");

		// View Mode Edit Calculated
		editCalculatedJSP = getInitParameter("edit-Calculated-jsp");

		// View Mode Entry Calculated
		viewCalculatedJSP = getInitParameter("view-Calculated-jsp");
	}

	protected void include(String path, RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		PortletRequestDispatcher portletRequestDispatcher = getPortletContext()
				.getRequestDispatcher(path);

		if (portletRequestDispatcher == null) {
			// do nothing
			// _log.error(path + " is not a valid include");
		} else {
			portletRequestDispatcher.include(renderRequest, renderResponse);
		}
	}

	public void doView(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		String jsp = (String) renderRequest.getParameter("view");
		if (jsp == null || jsp.equals("")) {
			showViewDefault(renderRequest, renderResponse);
		} else if (jsp.equalsIgnoreCase("editCalculated")) {
			try {
				showViewEditCalculated(renderRequest, renderResponse);
			} catch (Exception ex) {
				_log.debug(ex);
				try {
					showViewDefault(renderRequest, renderResponse);
				} catch (Exception ex1) {
					_log.debug(ex1);
				}
			}
		}
	}

	public void doEdit(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		showEditDefault(renderRequest, renderResponse);
	}

	public void doHelp(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		include(helpJSP, renderRequest, renderResponse);
	}

	@SuppressWarnings("unchecked")
	public void showViewDefault(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		ThemeDisplay themeDisplay = (ThemeDisplay) renderRequest
				.getAttribute(WebKeys.THEME_DISPLAY);

		long groupId = themeDisplay.getScopeGroupId();

		PermissionChecker permissionChecker = themeDisplay
				.getPermissionChecker();

		boolean hasAddPermission = CalculatedPermission.contains(permissionChecker, groupId, "ADD_CALCULATED");

		boolean hasModelPermissions = CalculatedPermission.contains(permissionChecker, groupId, ActionKeys.PERMISSIONS);

		List<Calculated> tempResults = Collections.EMPTY_LIST;

		PortletPreferences prefs = renderRequest.getPreferences();

		String CalculatedFilter = ParamUtil.getString(renderRequest, "CalculatedFilter");

		String rowsPerPage = prefs.getValue("rows-per-page","5");

		Integer cur = 1;
		int containerStart = 0;
		int containerEnd = 0;
		String orderByType = renderRequest.getParameter("orderByType");
		String orderByCol = renderRequest.getParameter("orderByCol");
		try{
			cur = ParamUtil.getInteger(renderRequest, "cur");

		}catch (Exception e){
			cur = 1;
		}

		if (cur < 1){
			cur = 1;
		}

		if (Validator.isNotNull(CalculatedFilter) || !CalculatedFilter.equalsIgnoreCase("")) {
			rowsPerPage = "100";
			cur = 1;
		}

		containerStart = (cur - 1) * Integer.parseInt(rowsPerPage);
		containerEnd = containerStart + Integer.parseInt(rowsPerPage);

		int total = 0;
		try {
			PortalPreferences portalPrefs = PortletPreferencesFactoryUtil.getPortalPreferences(renderRequest);

			if (Validator.isNull(orderByCol) && Validator.isNull(orderByType)) {
				orderByCol = portalPrefs.getValue("Calculated_order", "Calculated-order-by-col", "calculatedId");
				orderByType = portalPrefs.getValue("Calculated_order", "Calculated-order-by-type", "asc");
			}
			OrderByComparator comparator = CalculatedComparator.getCalculatedOrderByComparator(orderByCol,orderByType);



			if (CalculatedFilter.equalsIgnoreCase("")) {
				tempResults = CalculatedLocalServiceUtil.findAllInGroup(groupId, containerStart, containerEnd, comparator);
				total = CalculatedLocalServiceUtil.countAllInGroup(groupId);

			} else {

				Indexer indexer = IndexerRegistryUtil.getIndexer(Calculated.class);

				SearchContext searchContext = SearchContextFactory.getInstance(PortalUtil.getHttpServletRequest(renderRequest));

				searchContext.setEnd(containerEnd);
				searchContext.setKeywords(CalculatedFilter);
				searchContext.setStart(containerStart);

				Hits results = indexer.search(searchContext);

				total = results.getLength();

				if (total > 0) {
					tempResults = new ArrayList<Calculated>(total);
				}
				for (int i = 0; i < results.getDocs().length; i++) {
					Document doc = results.doc(i);

					Calculated resReg = null;

					// Entry
					long entryId = GetterUtil.getLong(doc.get(Field.ENTRY_CLASS_PK));

					try {
						resReg = CalculatedLocalServiceUtil.getCalculated(entryId);

						resReg = resReg.toEscapedModel();

						tempResults.add(resReg);
					}
					catch (Exception e) {
						if (_log.isWarnEnabled()) {
							_log.warn("Calculated search index is stale and contains entry " + entryId);
						}

						continue;
					}
				}
			}

		} catch (Exception e) {
			_log.debug(e);
		}
		renderRequest.setAttribute("highlightRowWithKey", renderRequest.getParameter("highlightRowWithKey"));
		renderRequest.setAttribute("containerStart", containerStart);
		renderRequest.setAttribute("containerEnd", containerEnd);
		renderRequest.setAttribute("cur", cur);
		renderRequest.setAttribute("tempResults", tempResults);
		renderRequest.setAttribute("totalCount", total);
		renderRequest.setAttribute("rowsPerPage", rowsPerPage);
		renderRequest.setAttribute("hasAddPermission", hasAddPermission);
		renderRequest.setAttribute("hasModelPermissions", hasModelPermissions);
		renderRequest.setAttribute("orderByType", orderByType);
		renderRequest.setAttribute("orderByCol", orderByCol);

		PortletURL addCalculatedURL = renderResponse.createActionURL();
		addCalculatedURL.setParameter("javax.portlet.action", "newCalculated");
		renderRequest.setAttribute("addCalculatedURL", addCalculatedURL.toString());

		PortletURL CalculatedFilterURL = renderResponse.createRenderURL();
		CalculatedFilterURL.setParameter("javax.portlet.action", "doView");
		renderRequest.setAttribute("CalculatedFilterURL", CalculatedFilterURL.toString());

		include(viewJSP, renderRequest, renderResponse);
	}

	public void showViewEditCalculated(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
		
		ThemeDisplay themeDisplay = (ThemeDisplay) renderRequest.getAttribute(WebKeys.THEME_DISPLAY);
		PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

		PortletURL editCalculatedURL = renderResponse.createActionURL();
		String editType = (String) renderRequest.getParameter("editType");

		Calculated calculated = null;
		boolean viewEntryMode=false;
		if (editType.equalsIgnoreCase("edit")) {
			editCalculatedURL.setParameter("javax.portlet.action", "updateCalculated");

			long $fname = Long.parseLong(renderRequest.getParameter("calculatedId"));
			calculated = CalculatedLocalServiceUtil.getCalculated($fname);

            	     	renderRequest.setAttribute("calculated", calculated);
		} else if (editType.equalsIgnoreCase("view")) {

			viewEntryMode= true;

			long $fname = Long.parseLong(renderRequest.getParameter("calculatedId"));
			calculated = CalculatedLocalServiceUtil.getCalculated($fname);


			if (!CalculatedEntryPermission.contains(
				permissionChecker, calculated, ActionKeys.VIEW)){							
				SessionErrors.add(renderRequest, "permission-error");
				return;
	     		}
			
			renderRequest.setAttribute("calculated", calculated);
		} else {
			editCalculatedURL.setParameter("javax.portlet.action", "addCalculated");
			Calculated errorCalculated = (Calculated) renderRequest.getAttribute("errorCalculated");
			if (errorCalculated != null) {
				if (editType.equalsIgnoreCase("update")) {
					editCalculatedURL.setParameter("javax.portlet.action", "updateCalculated");
                		}
				renderRequest.setAttribute("calculated", errorCalculated);

			} else {				
				
				Calculated addCalculated = null;


				if (Validator.isNull(renderRequest.getParameter("addErrors"))){
				
					addCalculated = new CalculatedImpl();
					addCalculated.setCalculatedId(0);
					addCalculated.setCalculatedName("");
					addCalculated.setPrice(0);
					addCalculated.setPercentDiscount(0);
					addCalculated.setPercentVAT(0);
				}else{
					addCalculated = CalculatedFromRequest(renderRequest);
				}
				renderRequest.setAttribute("calculated", addCalculated);
			}

		}		

		if (!viewEntryMode){
			renderRequest.setAttribute("editCalculatedURL", editCalculatedURL.toString());		
			include(editCalculatedJSP, renderRequest, renderResponse);
		}else{
			include(viewCalculatedJSP, renderRequest, renderResponse);
		}
	}

	private String dateToJsp(ActionRequest request, Date date) {
		PortletPreferences prefs = request.getPreferences();
		return dateToJsp(prefs, date);
	}
	private String dateToJsp(RenderRequest request, Date date) {
		PortletPreferences prefs = request.getPreferences();
		return dateToJsp(prefs, date);
	}
	private String dateToJsp(PortletPreferences prefs, Date date) {
		SimpleDateFormat format = new SimpleDateFormat(prefs.getValue("date-format", "yyyy/MM/dd"));
		String stringDate = format.format(date);
		return stringDate;
	}
	private String dateTimeToJsp(Date date) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
		String stringDate = format.format(date);
		return stringDate;
	}

	public void showEditDefault(RenderRequest renderRequest,
			RenderResponse renderResponse) throws PortletException, IOException {

		include(editJSP, renderRequest, renderResponse);
	}

	/* Portlet Actions */

	@ProcessAction(name = "newCalculated")
	public void newCalculated(ActionRequest request, ActionResponse response) throws Exception{
		CalculatedUtil.addParametersForAdd(response);
	}

	@ProcessAction(name = "addCalculated")
	public void addCalculated(ActionRequest request, ActionResponse response) throws Exception {
            Calculated calculated = CalculatedFromRequest(request);
	    ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
	    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

	    if (!CalculatedPermission.contains(
					permissionChecker, themeDisplay.getScopeGroupId(), "ADD_CALCULATED")){	
				CalculatedUtil.addParametersForDefaultView(response);						
				SessionErrors.add(request, "permission-error");
				return;
	    }
            ArrayList<String> errors = CalculatedValidator.validateCalculated(calculated, request);

            if (errors.isEmpty()) {
		try {
			ServiceContext serviceContext = ServiceContextFactory.getInstance(Calculated.class.getName(), request);
			CalculatedLocalServiceUtil.addCalculated(calculated, serviceContext);

			CalculatedUtil.addParametersForDefaultView(response);
                	SessionMessages.add(request, "calculated-added-successfully");

            	} catch (Exception cvex) {
            		SessionErrors.add(request, "please-enter-a-unique-code");
			PortalUtil.copyRequestParameters(request, response);			
			CalculatedUtil.addParametersForAddWithErrors(response);		
            	}
            } else {
                for (String error : errors) {
                        SessionErrors.add(request, error);
                }
		PortalUtil.copyRequestParameters(request, response);			
		CalculatedUtil.addParametersForAddWithErrors(response);	
            }
	}

	@ProcessAction(name = "eventCalculated")
	public void eventCalculated(ActionRequest request, ActionResponse response)
			throws Exception {
		long key = ParamUtil.getLong(request, "resourcePrimKey");
		int containerStart = ParamUtil.getInteger(request, "containerStart");
		int containerEnd = ParamUtil.getInteger(request, "containerEnd");
		int cur = ParamUtil.getInteger(request, "cur");
		String orderByType = ParamUtil.getString(request, "orderByType");
		String orderByCol = ParamUtil.getString(request, "orderByCol");
		String calculatedFilter = ParamUtil.getString(request, "CalculatedFilter");
		if (Validator.isNotNull(key)) {
            		response.setRenderParameter("highlightRowWithKey", Long.toString(key));
            		response.setRenderParameter("containerStart", Integer.toString(containerStart));
            		response.setRenderParameter("containerEnd", Integer.toString(containerEnd));
			response.setRenderParameter("cur", Integer.toString(cur));
			response.setRenderParameter("orderByType", orderByType);
			response.setRenderParameter("orderByCol", orderByCol);
			response.setRenderParameter("CalculatedFilter", calculatedFilter);
		}
	}

	@ProcessAction(name = "editCalculated")
	public void editCalculated(ActionRequest request, ActionResponse response)
			throws Exception {
		long key = ParamUtil.getLong(request, "resourcePrimKey");
		if (Validator.isNotNull(key)) {
			CalculatedUtil.addParametersForEdit(response, key);
			
		}
	}

	@ProcessAction(name = "deleteCalculated")
	public void deleteCalculated(ActionRequest request, ActionResponse response)throws Exception {		

		long id = ParamUtil.getLong(request, "resourcePrimKey");

		if (Validator.isNotNull(id)) {
			ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
			PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

			if (!CalculatedEntryPermission.contains(
					permissionChecker, id, ActionKeys.DELETE)){	
				CalculatedUtil.addParametersForDefaultView(response);						
				SessionErrors.add(request, "permission-error");
				return;
			}

			Calculated calculated = CalculatedLocalServiceUtil.getCalculated(id);
			CalculatedLocalServiceUtil.deleteCalculatedEntry(calculated);
			SessionMessages.add(request, "calculated-deleted-successfully");
            		response.setRenderParameter("calculatedId", "0");
		} else {
			SessionErrors.add(request, "calculated-error-deleting");
		}
	}

	@ProcessAction(name = "updateCalculated")
	public void updateCalculated(ActionRequest request, ActionResponse response) throws Exception {
            Calculated calculated = CalculatedFromRequest(request);
	    ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
	    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

	    if (!CalculatedEntryPermission.contains(
				permissionChecker, calculated, ActionKeys.UPDATE)){	
				CalculatedUtil.addParametersForDefaultView(response);						
				SessionErrors.add(request, "permission-error");
				return;
	     }

            ArrayList<String> errors = CalculatedValidator.validateCalculated(calculated, request);

            if (errors.isEmpty()) {
            	try {
			ServiceContext serviceContext = ServiceContextFactory.getInstance(Calculated.class.getName(), request);
                	CalculatedLocalServiceUtil.updateCalculated(calculated, serviceContext);

			CalculatedUtil.addParametersForDefaultView(response);
                	SessionMessages.add(request, "calculated-updated-successfully");

            	} catch (Exception cvex) {
            	    SessionErrors.add(request, "please-enter-a-unique-code");
		    		CalculatedUtil.addParametersForEdit(response, null);
					request.setAttribute("calculated",calculated);
            	}
            } else {
                for (String error : errors) {
                        SessionErrors.add(request, error);
                }
				CalculatedUtil.addParametersForEdit(response, Long.toString(calculated.getPrimaryKey()));
				request.setAttribute("calculated",calculated);
            }
        }

	@ProcessAction(name = "setCalculatedPref")
	public void setCalculatedPref(ActionRequest request, ActionResponse response) throws Exception {

		String rowsPerPage = ParamUtil.getString(request, "rows-per-page");
		String dateFormat = ParamUtil.getString(request, "date-format");
		String datetimeFormat = ParamUtil.getString(request, "datetime-format");

		ArrayList<String> errors = new ArrayList();
		if (CalculatedValidator.validateEditCalculated(rowsPerPage, dateFormat, datetimeFormat, errors)) {
			response.setRenderParameter("rows-per-page", "");
			response.setRenderParameter("date-format", "");
			response.setRenderParameter("datetime-format", "");

			PortletPreferences prefs = request.getPreferences();
			prefs.setValue("rows-per-page", rowsPerPage);
			prefs.setValue("date-format", dateFormat);
			prefs.setValue("datetime-format", datetimeFormat);
			prefs.store();

			SessionMessages.add(request, "prefs-success");
		}
	}

	private Calculated CalculatedFromRequest(PortletRequest request) {
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
		CalculatedImpl calculated = new CalculatedImpl();
        	try {
            		calculated.setCalculatedId(ParamUtil.getLong(request, "calculatedId"));
        	} catch (Exception nfe) {
		    //Controled en Validator
        	}
		calculated.setCalculatedName(ParamUtil.getString(request, "calculatedName"));
        	try {
	         	calculated.setPrice(ParamUtil.getDouble(request, "price"));
        	} catch (NumberFormatException nfe) {
			//Controled en Validator
        	}
        	try {
	         	calculated.setPercentDiscount(ParamUtil.getDouble(request, "percentDiscount"));
        	} catch (NumberFormatException nfe) {
			//Controled en Validator
        	}
        	try {
	         	calculated.setPercentVAT(ParamUtil.getDouble(request, "percentVAT"));
        	} catch (NumberFormatException nfe) {
			//Controled en Validator
        	}
		try {
		    	calculated.setPrimaryKey(ParamUtil.getLong(request,"resourcePrimKey"));
		} catch (NumberFormatException nfe) {
			//Controled en Validator
        	}

		calculated.setCompanyId(themeDisplay.getCompanyId());
		calculated.setGroupId(themeDisplay.getScopeGroupId());
		calculated.setUserId(themeDisplay.getUserId());
		return calculated;
	}



	public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
		resourceResponse.setContentType("text/javascript");
		String resourceId = resourceRequest.getResourceID();

		if (Validator.isNotNull(resourceId) && resourceId.length() != 0) {

			if(resourceId.equalsIgnoreCase("exportFullCalculatedResourceURL")) {

		    		ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute(WebKeys.THEME_DISPLAY);
		    		Locale locale = themeDisplay.getLocale();
		    		PortletConfig portletConfig = (PortletConfig)resourceRequest.getAttribute(JavaConstants.JAVAX_PORTLET_CONFIG);

		    		resourceResponse.setContentType("application/vnd.ms-excel");
		    		resourceResponse.setProperty("expires","-1d");
		    		resourceResponse.setProperty("Pragma","no-cache");
		    		resourceResponse.setProperty("Cache-control","no-cache");
				resourceResponse.addProperty(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\" Calculated\"");

				try {
					Workbook book = CalculatedExporter.generateFullExcel(themeDisplay.getScopeGroupId(), portletConfig, locale);
					OutputStream out = resourceResponse.getPortletOutputStream();
					book.write(out);
					out.flush();
					out.close();
				} catch (SystemException e) {
					e.printStackTrace();
					throw new PortletException("Export Excel Error",e);
				}
			}

		}
	}

	protected String editCalculatedJSP;
	protected String editJSP;
	protected String helpJSP;
	protected String viewJSP;
	protected String viewCalculatedJSP;

	private static Log _log = LogFactoryUtil.getLog(CalculatedPortlet.class);

}