/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
 
 package org.xmlportletfactory.xmlpf.calculated;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.portlet.ActionRequest;

import org.xmlportletfactory.xmlpf.calculated.model.Calculated;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.ParamUtil;

public class CalculatedValidator {

	public static ArrayList<String> validateCalculated(Calculated calculated, ActionRequest request) throws IOException {
		ArrayList<String> errors = new ArrayList<String>();
		Properties props = new Properties();
		ClassLoader classLoader = CalculatedValidator.class.getClassLoader();
		InputStream is = classLoader.getResourceAsStream("regexp.properties");
		props.load(is);


	//Field calculatedName
	
	
		if(!validateCalculatedName(props, ParamUtil.getString(request, "calculatedName"))){
		    errors.add("error");
		}
		if (Validator.isNull(calculated.getCalculatedName())) {
			errors.add("Calculated-calculatedname-required");
		}

	//Field price
	
	
		if(!validatePrice(props, ParamUtil.getString(request, "price"))){
		    errors.add("error_number_format");
		}

	//Field percentDiscount
	
	
		if(!validatePercentDiscount(props, ParamUtil.getString(request, "percentDiscount"))){
		    errors.add("error_number_format");
		}

	//Field percentVAT
	
	
		if(!validatePercentVAT(props, ParamUtil.getString(request, "percentVAT"))){
		    errors.add("error_number_format");
		}

	//Field calculatedTotal
	
	
		if(!validateCalculatedTotal(props, ParamUtil.getString(request, "calculatedTotal"))){
		    errors.add("error");
		}
		return errors;
	}

	public static boolean validateEditCalculated(
		String rowsPerPage, String dateFormat, String datetimeFormat, List errors) {
		boolean valid = true;
		if (Validator.isNull(rowsPerPage)) {
			errors.add("rows-per-page-required");
			valid = false;
		} else if (!Validator.isNumber(rowsPerPage)) {
			errors.add("rows-per-page-invalid");
			valid = false;
		} else if (Validator.isNull(dateFormat)) {
			errors.add("date-format-required");
			valid = false;
		} else if (Validator.isNull(datetimeFormat)) {
			errors.add("datetime-format.required");
			valid = false;
		}
		return valid;
	}

	//Field calculatedId
	private static boolean validateCalculatedId(Properties props,String field) {
		boolean valid = true;
		try {
			Double.parseDouble(field);
		} catch (NumberFormatException nfe) {
		    valid = false;
		}
		return valid;
	}
	//Field calculatedName
	private static boolean validateCalculatedName(Properties props,String field) {
		boolean valid = true;
		return valid;
	}
	//Field price
	private static boolean validatePrice(Properties props,String field) {
		boolean valid = true;
		try {
			Double.parseDouble(field);
		} catch (NumberFormatException nfe) {
		    valid = false;
		}
		return valid;
	}
	//Field percentDiscount
	private static boolean validatePercentDiscount(Properties props,String field) {
		boolean valid = true;
		try {
			Double.parseDouble(field);
		} catch (NumberFormatException nfe) {
		    valid = false;
		}
		return valid;
	}
	//Field percentVAT
	private static boolean validatePercentVAT(Properties props,String field) {
		boolean valid = true;
		try {
			Double.parseDouble(field);
		} catch (NumberFormatException nfe) {
		    valid = false;
		}
		return valid;
	}
	//Field calculatedTotal
	private static boolean validateCalculatedTotal(Properties props,String field) {
		boolean valid = true;
		return valid;
	}
}
