/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.service.base;

import com.liferay.counter.service.CounterLocalService;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.PersistedModel;
import com.liferay.portal.service.BaseLocalServiceImpl;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.service.ResourceLocalService;
import com.liferay.portal.service.ResourceService;
import com.liferay.portal.service.UserLocalService;
import com.liferay.portal.service.UserService;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.UserPersistence;

import org.xmlportletfactory.xmlpf.calculated.model.Calculated;
import org.xmlportletfactory.xmlpf.calculated.service.CalculatedLocalService;
import org.xmlportletfactory.xmlpf.calculated.service.persistence.CalculatedPersistence;

import java.io.Serializable;

import java.util.List;

import javax.sql.DataSource;

/**
 * The base implementation of the calculated local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link org.xmlportletfactory.xmlpf.calculated.service.impl.CalculatedLocalServiceImpl}.
 * </p>
 *
 * @author Jack A. Rider
 * @see org.xmlportletfactory.xmlpf.calculated.service.impl.CalculatedLocalServiceImpl
 * @see org.xmlportletfactory.xmlpf.calculated.service.CalculatedLocalServiceUtil
 * @generated
 */
public abstract class CalculatedLocalServiceBaseImpl
	extends BaseLocalServiceImpl implements CalculatedLocalService,
		IdentifiableBean {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Always use {@link org.xmlportletfactory.xmlpf.calculated.service.CalculatedLocalServiceUtil} to access the calculated local service.
	 */

	/**
	 * Adds the calculated to the database. Also notifies the appropriate model listeners.
	 *
	 * @param calculated the calculated
	 * @return the calculated that was added
	 * @throws SystemException if a system exception occurred
	 */
	@Indexable(type = IndexableType.REINDEX)
	public Calculated addCalculated(Calculated calculated)
		throws SystemException {
		calculated.setNew(true);

		return calculatedPersistence.update(calculated, false);
	}

	/**
	 * Creates a new calculated with the primary key. Does not add the calculated to the database.
	 *
	 * @param calculatedId the primary key for the new calculated
	 * @return the new calculated
	 */
	public Calculated createCalculated(long calculatedId) {
		return calculatedPersistence.create(calculatedId);
	}

	/**
	 * Deletes the calculated with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * @param calculatedId the primary key of the calculated
	 * @return the calculated that was removed
	 * @throws PortalException if a calculated with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	@Indexable(type = IndexableType.DELETE)
	public Calculated deleteCalculated(long calculatedId)
		throws PortalException, SystemException {
		return calculatedPersistence.remove(calculatedId);
	}

	/**
	 * Deletes the calculated from the database. Also notifies the appropriate model listeners.
	 *
	 * @param calculated the calculated
	 * @return the calculated that was removed
	 * @throws SystemException if a system exception occurred
	 */
	@Indexable(type = IndexableType.DELETE)
	public Calculated deleteCalculated(Calculated calculated)
		throws SystemException {
		return calculatedPersistence.remove(calculated);
	}

	public DynamicQuery dynamicQuery() {
		Class<?> clazz = getClass();

		return DynamicQueryFactoryUtil.forClass(Calculated.class,
			clazz.getClassLoader());
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 * @throws SystemException if a system exception occurred
	 */
	@SuppressWarnings("rawtypes")
	public List dynamicQuery(DynamicQuery dynamicQuery)
		throws SystemException {
		return calculatedPersistence.findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 * @throws SystemException if a system exception occurred
	 */
	@SuppressWarnings("rawtypes")
	public List dynamicQuery(DynamicQuery dynamicQuery, int start, int end)
		throws SystemException {
		return calculatedPersistence.findWithDynamicQuery(dynamicQuery, start,
			end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 * @throws SystemException if a system exception occurred
	 */
	@SuppressWarnings("rawtypes")
	public List dynamicQuery(DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator orderByComparator) throws SystemException {
		return calculatedPersistence.findWithDynamicQuery(dynamicQuery, start,
			end, orderByComparator);
	}

	/**
	 * Returns the number of rows that match the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows that match the dynamic query
	 * @throws SystemException if a system exception occurred
	 */
	public long dynamicQueryCount(DynamicQuery dynamicQuery)
		throws SystemException {
		return calculatedPersistence.countWithDynamicQuery(dynamicQuery);
	}

	public Calculated fetchCalculated(long calculatedId)
		throws SystemException {
		return calculatedPersistence.fetchByPrimaryKey(calculatedId);
	}

	/**
	 * Returns the calculated with the primary key.
	 *
	 * @param calculatedId the primary key of the calculated
	 * @return the calculated
	 * @throws PortalException if a calculated with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	public Calculated getCalculated(long calculatedId)
		throws PortalException, SystemException {
		return calculatedPersistence.findByPrimaryKey(calculatedId);
	}

	public PersistedModel getPersistedModel(Serializable primaryKeyObj)
		throws PortalException, SystemException {
		return calculatedPersistence.findByPrimaryKey(primaryKeyObj);
	}

	/**
	 * Returns a range of all the calculateds.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	 * </p>
	 *
	 * @param start the lower bound of the range of calculateds
	 * @param end the upper bound of the range of calculateds (not inclusive)
	 * @return the range of calculateds
	 * @throws SystemException if a system exception occurred
	 */
	public List<Calculated> getCalculateds(int start, int end)
		throws SystemException {
		return calculatedPersistence.findAll(start, end);
	}

	/**
	 * Returns the number of calculateds.
	 *
	 * @return the number of calculateds
	 * @throws SystemException if a system exception occurred
	 */
	public int getCalculatedsCount() throws SystemException {
		return calculatedPersistence.countAll();
	}

	/**
	 * Updates the calculated in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * @param calculated the calculated
	 * @return the calculated that was updated
	 * @throws SystemException if a system exception occurred
	 */
	@Indexable(type = IndexableType.REINDEX)
	public Calculated updateCalculated(Calculated calculated)
		throws SystemException {
		return updateCalculated(calculated, true);
	}

	/**
	 * Updates the calculated in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * @param calculated the calculated
	 * @param merge whether to merge the calculated with the current session. See {@link com.liferay.portal.service.persistence.BatchSession#update(com.liferay.portal.kernel.dao.orm.Session, com.liferay.portal.model.BaseModel, boolean)} for an explanation.
	 * @return the calculated that was updated
	 * @throws SystemException if a system exception occurred
	 */
	@Indexable(type = IndexableType.REINDEX)
	public Calculated updateCalculated(Calculated calculated, boolean merge)
		throws SystemException {
		calculated.setNew(false);

		return calculatedPersistence.update(calculated, merge);
	}

	/**
	 * Returns the calculated local service.
	 *
	 * @return the calculated local service
	 */
	public CalculatedLocalService getCalculatedLocalService() {
		return calculatedLocalService;
	}

	/**
	 * Sets the calculated local service.
	 *
	 * @param calculatedLocalService the calculated local service
	 */
	public void setCalculatedLocalService(
		CalculatedLocalService calculatedLocalService) {
		this.calculatedLocalService = calculatedLocalService;
	}

	/**
	 * Returns the calculated persistence.
	 *
	 * @return the calculated persistence
	 */
	public CalculatedPersistence getCalculatedPersistence() {
		return calculatedPersistence;
	}

	/**
	 * Sets the calculated persistence.
	 *
	 * @param calculatedPersistence the calculated persistence
	 */
	public void setCalculatedPersistence(
		CalculatedPersistence calculatedPersistence) {
		this.calculatedPersistence = calculatedPersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public CounterLocalService getCounterLocalService() {
		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(CounterLocalService counterLocalService) {
		this.counterLocalService = counterLocalService;
	}

	/**
	 * Returns the resource local service.
	 *
	 * @return the resource local service
	 */
	public ResourceLocalService getResourceLocalService() {
		return resourceLocalService;
	}

	/**
	 * Sets the resource local service.
	 *
	 * @param resourceLocalService the resource local service
	 */
	public void setResourceLocalService(
		ResourceLocalService resourceLocalService) {
		this.resourceLocalService = resourceLocalService;
	}

	/**
	 * Returns the resource remote service.
	 *
	 * @return the resource remote service
	 */
	public ResourceService getResourceService() {
		return resourceService;
	}

	/**
	 * Sets the resource remote service.
	 *
	 * @param resourceService the resource remote service
	 */
	public void setResourceService(ResourceService resourceService) {
		this.resourceService = resourceService;
	}

	/**
	 * Returns the resource persistence.
	 *
	 * @return the resource persistence
	 */
	public ResourcePersistence getResourcePersistence() {
		return resourcePersistence;
	}

	/**
	 * Sets the resource persistence.
	 *
	 * @param resourcePersistence the resource persistence
	 */
	public void setResourcePersistence(ResourcePersistence resourcePersistence) {
		this.resourcePersistence = resourcePersistence;
	}

	/**
	 * Returns the user local service.
	 *
	 * @return the user local service
	 */
	public UserLocalService getUserLocalService() {
		return userLocalService;
	}

	/**
	 * Sets the user local service.
	 *
	 * @param userLocalService the user local service
	 */
	public void setUserLocalService(UserLocalService userLocalService) {
		this.userLocalService = userLocalService;
	}

	/**
	 * Returns the user remote service.
	 *
	 * @return the user remote service
	 */
	public UserService getUserService() {
		return userService;
	}

	/**
	 * Sets the user remote service.
	 *
	 * @param userService the user remote service
	 */
	public void setUserService(UserService userService) {
		this.userService = userService;
	}

	/**
	 * Returns the user persistence.
	 *
	 * @return the user persistence
	 */
	public UserPersistence getUserPersistence() {
		return userPersistence;
	}

	/**
	 * Sets the user persistence.
	 *
	 * @param userPersistence the user persistence
	 */
	public void setUserPersistence(UserPersistence userPersistence) {
		this.userPersistence = userPersistence;
	}

	public void afterPropertiesSet() {
		PersistedModelLocalServiceRegistryUtil.register("org.xmlportletfactory.xmlpf.calculated.model.Calculated",
			calculatedLocalService);
	}

	public void destroy() {
		PersistedModelLocalServiceRegistryUtil.unregister(
			"org.xmlportletfactory.xmlpf.calculated.model.Calculated");
	}

	/**
	 * Returns the Spring bean ID for this bean.
	 *
	 * @return the Spring bean ID for this bean
	 */
	public String getBeanIdentifier() {
		return _beanIdentifier;
	}

	/**
	 * Sets the Spring bean ID for this bean.
	 *
	 * @param beanIdentifier the Spring bean ID for this bean
	 */
	public void setBeanIdentifier(String beanIdentifier) {
		_beanIdentifier = beanIdentifier;
	}

	public Object invokeMethod(String name, String[] parameterTypes,
		Object[] arguments) throws Throwable {
		return _clpInvoker.invokeMethod(name, parameterTypes, arguments);
	}

	protected Class<?> getModelClass() {
		return Calculated.class;
	}

	protected String getModelClassName() {
		return Calculated.class.getName();
	}

	/**
	 * Performs an SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) throws SystemException {
		try {
			DataSource dataSource = calculatedPersistence.getDataSource();

			SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource,
					sql, new int[0]);

			sqlUpdate.update();
		}
		catch (Exception e) {
			throw new SystemException(e);
		}
	}

	@BeanReference(type = CalculatedLocalService.class)
	protected CalculatedLocalService calculatedLocalService;
	@BeanReference(type = CalculatedPersistence.class)
	protected CalculatedPersistence calculatedPersistence;
	@BeanReference(type = CounterLocalService.class)
	protected CounterLocalService counterLocalService;
	@BeanReference(type = ResourceLocalService.class)
	protected ResourceLocalService resourceLocalService;
	@BeanReference(type = ResourceService.class)
	protected ResourceService resourceService;
	@BeanReference(type = ResourcePersistence.class)
	protected ResourcePersistence resourcePersistence;
	@BeanReference(type = UserLocalService.class)
	protected UserLocalService userLocalService;
	@BeanReference(type = UserService.class)
	protected UserService userService;
	@BeanReference(type = UserPersistence.class)
	protected UserPersistence userPersistence;
	private String _beanIdentifier;
	private CalculatedLocalServiceClpInvoker _clpInvoker = new CalculatedLocalServiceClpInvoker();
}