<%
/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
%> 
<%@include file="../init.jsp" %>
<%@ page import="org.xmlportletfactory.xmlpf.calculated.model.Calculated" %>
<%@ page import="com.liferay.portal.kernel.util.StringPool" %>
<%@ page import="com.liferay.portal.kernel.util.HttpUtil" %>
<%@ page import="com.liferay.portal.kernel.util.HtmlUtil" %>
<%@ page import="javax.script.ScriptEngine" %>
<%@ page import="javax.script.ScriptEngineManager" %>	


<jsp:useBean class="java.lang.String" id="editCalculatedURL" scope="request" />
<jsp:useBean id="calculated" type="org.xmlportletfactory.xmlpf.calculated.model.Calculated" scope="request"/>


<portlet:defineObjects />



<portlet:renderURL var="redirect"></portlet:renderURL>

<div class="entry">




			<span class="aui-field-content">
				<label class="aui-field-label"> 
					<liferay-ui:message key="calculated-calculatedname" />
				</label>
				<span class="aui-field-element">
					<%= calculated.getCalculatedName() %>
				</span>
			</span>

			<span class="aui-field-content">
				<label class="aui-field-label"> 
					<liferay-ui:message key="calculated-price" />
				</label>
				<span class="aui-field-element">
					<%= calculated.getPrice() %>
				</span>
			</span>

			<span class="aui-field-content">
				<label class="aui-field-label"> 
					<liferay-ui:message key="calculated-percentdiscount" />
				</label>
				<span class="aui-field-element">
					<%= calculated.getPercentDiscount() %>
				</span>
			</span>

			<span class="aui-field-content">
				<label class="aui-field-label"> 
					<liferay-ui:message key="calculated-percentvat" />
				</label>
				<span class="aui-field-element">
					<%= calculated.getPercentVAT() %>
				</span>
			</span>
		<%	
			String calculatedTotalIncoming = "(price-(price*(percentDiscount/100)))+(price*(percentVAT/100))";
			
			String calculatedTotalDelims = "(?<=op)|(?=op)".replace("op", "[-+*/()]");
			
			String[] calculatedTotalTokens = calculatedTotalIncoming.split(calculatedTotalDelims);
			
			StringBuilder calculatedTotalSB = new StringBuilder();

			for (int i = 0; i < calculatedTotalTokens.length; i++) {
				 if ( calculatedTotalTokens[i].toString().equals("price") ) {
	            	calculatedTotalSB.append(String.valueOf(calculated.getPrice()));
	            }
				else if ( calculatedTotalTokens[i].toString().equals("percentDiscount") ) {
	            	calculatedTotalSB.append(String.valueOf(calculated.getPercentDiscount()));
	            }
				else if ( calculatedTotalTokens[i].toString().equals("percentVAT") ) {
	            	calculatedTotalSB.append(String.valueOf(calculated.getPercentVAT()));
	            }
	            else {
	            	calculatedTotalSB.append(calculatedTotalTokens[i].toString());
	            }
	        } 		
			
			ScriptEngineManager calculatedTotalMgr = new ScriptEngineManager();
        	ScriptEngine calculatedTotalEngine = calculatedTotalMgr.getEngineByName("JavaScript");
        	String calculatedTotal = calculatedTotalEngine.eval(calculatedTotalSB.toString()).toString();
		%>

			<span class="aui-field-content">
				<label class="aui-field-label"> 
					<liferay-ui:message key="calculated-calculatedtotal" />
				</label>
				<span class="aui-field-element">
					<%= calculatedTotal %>
				</span>
			</span>



</div>
