/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Calculated service. Represents a row in the &quot;calculated_Calculated&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link org.xmlportletfactory.xmlpf.calculated.model.impl.CalculatedModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link org.xmlportletfactory.xmlpf.calculated.model.impl.CalculatedImpl}.
 * </p>
 *
 * @author Jack A. Rider
 * @see Calculated
 * @see org.xmlportletfactory.xmlpf.calculated.model.impl.CalculatedImpl
 * @see org.xmlportletfactory.xmlpf.calculated.model.impl.CalculatedModelImpl
 * @generated
 */
public interface CalculatedModel extends BaseModel<Calculated>, GroupedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a calculated model instance should use the {@link Calculated} interface instead.
	 */

	/**
	 * Returns the primary key of this calculated.
	 *
	 * @return the primary key of this calculated
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this calculated.
	 *
	 * @param primaryKey the primary key of this calculated
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the calculated ID of this calculated.
	 *
	 * @return the calculated ID of this calculated
	 */
	public long getCalculatedId();

	/**
	 * Sets the calculated ID of this calculated.
	 *
	 * @param calculatedId the calculated ID of this calculated
	 */
	public void setCalculatedId(long calculatedId);

	/**
	 * Returns the company ID of this calculated.
	 *
	 * @return the company ID of this calculated
	 */
	public long getCompanyId();

	/**
	 * Sets the company ID of this calculated.
	 *
	 * @param companyId the company ID of this calculated
	 */
	public void setCompanyId(long companyId);

	/**
	 * Returns the group ID of this calculated.
	 *
	 * @return the group ID of this calculated
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this calculated.
	 *
	 * @param groupId the group ID of this calculated
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the user ID of this calculated.
	 *
	 * @return the user ID of this calculated
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this calculated.
	 *
	 * @param userId the user ID of this calculated
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this calculated.
	 *
	 * @return the user uuid of this calculated
	 * @throws SystemException if a system exception occurred
	 */
	public String getUserUuid() throws SystemException;

	/**
	 * Sets the user uuid of this calculated.
	 *
	 * @param userUuid the user uuid of this calculated
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this calculated.
	 *
	 * @return the user name of this calculated
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this calculated.
	 *
	 * @param userName the user name of this calculated
	 */
	public void setUserName(String userName);

	/**
	 * Returns the create date of this calculated.
	 *
	 * @return the create date of this calculated
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this calculated.
	 *
	 * @param createDate the create date of this calculated
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this calculated.
	 *
	 * @return the modified date of this calculated
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this calculated.
	 *
	 * @param modifiedDate the modified date of this calculated
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the calculated name of this calculated.
	 *
	 * @return the calculated name of this calculated
	 */
	@AutoEscape
	public String getCalculatedName();

	/**
	 * Sets the calculated name of this calculated.
	 *
	 * @param calculatedName the calculated name of this calculated
	 */
	public void setCalculatedName(String calculatedName);

	/**
	 * Returns the price of this calculated.
	 *
	 * @return the price of this calculated
	 */
	public double getPrice();

	/**
	 * Sets the price of this calculated.
	 *
	 * @param price the price of this calculated
	 */
	public void setPrice(double price);

	/**
	 * Returns the percent discount of this calculated.
	 *
	 * @return the percent discount of this calculated
	 */
	public double getPercentDiscount();

	/**
	 * Sets the percent discount of this calculated.
	 *
	 * @param percentDiscount the percent discount of this calculated
	 */
	public void setPercentDiscount(double percentDiscount);

	/**
	 * Returns the percent v a t of this calculated.
	 *
	 * @return the percent v a t of this calculated
	 */
	public double getPercentVAT();

	/**
	 * Sets the percent v a t of this calculated.
	 *
	 * @param percentVAT the percent v a t of this calculated
	 */
	public void setPercentVAT(double percentVAT);

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public Serializable getPrimaryKeyObj();

	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(Calculated calculated);

	public int hashCode();

	public CacheModel<Calculated> toCacheModel();

	public Calculated toEscapedModel();

	public String toString();

	public String toXmlString();
}