/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author    Jack A. Rider
 * @generated
 */
public class CalculatedSoap implements Serializable {
	public static CalculatedSoap toSoapModel(Calculated model) {
		CalculatedSoap soapModel = new CalculatedSoap();

		soapModel.setCalculatedId(model.getCalculatedId());
		soapModel.setCompanyId(model.getCompanyId());
		soapModel.setGroupId(model.getGroupId());
		soapModel.setUserId(model.getUserId());
		soapModel.setUserName(model.getUserName());
		soapModel.setCreateDate(model.getCreateDate());
		soapModel.setModifiedDate(model.getModifiedDate());
		soapModel.setCalculatedName(model.getCalculatedName());
		soapModel.setPrice(model.getPrice());
		soapModel.setPercentDiscount(model.getPercentDiscount());
		soapModel.setPercentVAT(model.getPercentVAT());

		return soapModel;
	}

	public static CalculatedSoap[] toSoapModels(Calculated[] models) {
		CalculatedSoap[] soapModels = new CalculatedSoap[models.length];

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModel(models[i]);
		}

		return soapModels;
	}

	public static CalculatedSoap[][] toSoapModels(Calculated[][] models) {
		CalculatedSoap[][] soapModels = null;

		if (models.length > 0) {
			soapModels = new CalculatedSoap[models.length][models[0].length];
		}
		else {
			soapModels = new CalculatedSoap[0][0];
		}

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModels(models[i]);
		}

		return soapModels;
	}

	public static CalculatedSoap[] toSoapModels(List<Calculated> models) {
		List<CalculatedSoap> soapModels = new ArrayList<CalculatedSoap>(models.size());

		for (Calculated model : models) {
			soapModels.add(toSoapModel(model));
		}

		return soapModels.toArray(new CalculatedSoap[soapModels.size()]);
	}

	public CalculatedSoap() {
	}

	public long getPrimaryKey() {
		return _calculatedId;
	}

	public void setPrimaryKey(long pk) {
		setCalculatedId(pk);
	}

	public long getCalculatedId() {
		return _calculatedId;
	}

	public void setCalculatedId(long calculatedId) {
		_calculatedId = calculatedId;
	}

	public long getCompanyId() {
		return _companyId;
	}

	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	public long getGroupId() {
		return _groupId;
	}

	public void setGroupId(long groupId) {
		_groupId = groupId;
	}

	public long getUserId() {
		return _userId;
	}

	public void setUserId(long userId) {
		_userId = userId;
	}

	public String getUserName() {
		return _userName;
	}

	public void setUserName(String userName) {
		_userName = userName;
	}

	public Date getCreateDate() {
		return _createDate;
	}

	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		_modifiedDate = modifiedDate;
	}

	public String getCalculatedName() {
		return _calculatedName;
	}

	public void setCalculatedName(String calculatedName) {
		_calculatedName = calculatedName;
	}

	public double getPrice() {
		return _price;
	}

	public void setPrice(double price) {
		_price = price;
	}

	public double getPercentDiscount() {
		return _percentDiscount;
	}

	public void setPercentDiscount(double percentDiscount) {
		_percentDiscount = percentDiscount;
	}

	public double getPercentVAT() {
		return _percentVAT;
	}

	public void setPercentVAT(double percentVAT) {
		_percentVAT = percentVAT;
	}

	private long _calculatedId;
	private long _companyId;
	private long _groupId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private String _calculatedName;
	private double _price;
	private double _percentDiscount;
	private double _percentVAT;
}