/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.model;

import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Calculated}.
 * </p>
 *
 * @author    Jack A. Rider
 * @see       Calculated
 * @generated
 */
public class CalculatedWrapper implements Calculated, ModelWrapper<Calculated> {
	public CalculatedWrapper(Calculated calculated) {
		_calculated = calculated;
	}

	public Class<?> getModelClass() {
		return Calculated.class;
	}

	public String getModelClassName() {
		return Calculated.class.getName();
	}

	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("calculatedId", getCalculatedId());
		attributes.put("companyId", getCompanyId());
		attributes.put("groupId", getGroupId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("calculatedName", getCalculatedName());
		attributes.put("price", getPrice());
		attributes.put("percentDiscount", getPercentDiscount());
		attributes.put("percentVAT", getPercentVAT());

		return attributes;
	}

	public void setModelAttributes(Map<String, Object> attributes) {
		Long calculatedId = (Long)attributes.get("calculatedId");

		if (calculatedId != null) {
			setCalculatedId(calculatedId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String calculatedName = (String)attributes.get("calculatedName");

		if (calculatedName != null) {
			setCalculatedName(calculatedName);
		}

		Double price = (Double)attributes.get("price");

		if (price != null) {
			setPrice(price);
		}

		Double percentDiscount = (Double)attributes.get("percentDiscount");

		if (percentDiscount != null) {
			setPercentDiscount(percentDiscount);
		}

		Double percentVAT = (Double)attributes.get("percentVAT");

		if (percentVAT != null) {
			setPercentVAT(percentVAT);
		}
	}

	/**
	* Returns the primary key of this calculated.
	*
	* @return the primary key of this calculated
	*/
	public long getPrimaryKey() {
		return _calculated.getPrimaryKey();
	}

	/**
	* Sets the primary key of this calculated.
	*
	* @param primaryKey the primary key of this calculated
	*/
	public void setPrimaryKey(long primaryKey) {
		_calculated.setPrimaryKey(primaryKey);
	}

	/**
	* Returns the calculated ID of this calculated.
	*
	* @return the calculated ID of this calculated
	*/
	public long getCalculatedId() {
		return _calculated.getCalculatedId();
	}

	/**
	* Sets the calculated ID of this calculated.
	*
	* @param calculatedId the calculated ID of this calculated
	*/
	public void setCalculatedId(long calculatedId) {
		_calculated.setCalculatedId(calculatedId);
	}

	/**
	* Returns the company ID of this calculated.
	*
	* @return the company ID of this calculated
	*/
	public long getCompanyId() {
		return _calculated.getCompanyId();
	}

	/**
	* Sets the company ID of this calculated.
	*
	* @param companyId the company ID of this calculated
	*/
	public void setCompanyId(long companyId) {
		_calculated.setCompanyId(companyId);
	}

	/**
	* Returns the group ID of this calculated.
	*
	* @return the group ID of this calculated
	*/
	public long getGroupId() {
		return _calculated.getGroupId();
	}

	/**
	* Sets the group ID of this calculated.
	*
	* @param groupId the group ID of this calculated
	*/
	public void setGroupId(long groupId) {
		_calculated.setGroupId(groupId);
	}

	/**
	* Returns the user ID of this calculated.
	*
	* @return the user ID of this calculated
	*/
	public long getUserId() {
		return _calculated.getUserId();
	}

	/**
	* Sets the user ID of this calculated.
	*
	* @param userId the user ID of this calculated
	*/
	public void setUserId(long userId) {
		_calculated.setUserId(userId);
	}

	/**
	* Returns the user uuid of this calculated.
	*
	* @return the user uuid of this calculated
	* @throws SystemException if a system exception occurred
	*/
	public java.lang.String getUserUuid()
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculated.getUserUuid();
	}

	/**
	* Sets the user uuid of this calculated.
	*
	* @param userUuid the user uuid of this calculated
	*/
	public void setUserUuid(java.lang.String userUuid) {
		_calculated.setUserUuid(userUuid);
	}

	/**
	* Returns the user name of this calculated.
	*
	* @return the user name of this calculated
	*/
	public java.lang.String getUserName() {
		return _calculated.getUserName();
	}

	/**
	* Sets the user name of this calculated.
	*
	* @param userName the user name of this calculated
	*/
	public void setUserName(java.lang.String userName) {
		_calculated.setUserName(userName);
	}

	/**
	* Returns the create date of this calculated.
	*
	* @return the create date of this calculated
	*/
	public java.util.Date getCreateDate() {
		return _calculated.getCreateDate();
	}

	/**
	* Sets the create date of this calculated.
	*
	* @param createDate the create date of this calculated
	*/
	public void setCreateDate(java.util.Date createDate) {
		_calculated.setCreateDate(createDate);
	}

	/**
	* Returns the modified date of this calculated.
	*
	* @return the modified date of this calculated
	*/
	public java.util.Date getModifiedDate() {
		return _calculated.getModifiedDate();
	}

	/**
	* Sets the modified date of this calculated.
	*
	* @param modifiedDate the modified date of this calculated
	*/
	public void setModifiedDate(java.util.Date modifiedDate) {
		_calculated.setModifiedDate(modifiedDate);
	}

	/**
	* Returns the calculated name of this calculated.
	*
	* @return the calculated name of this calculated
	*/
	public java.lang.String getCalculatedName() {
		return _calculated.getCalculatedName();
	}

	/**
	* Sets the calculated name of this calculated.
	*
	* @param calculatedName the calculated name of this calculated
	*/
	public void setCalculatedName(java.lang.String calculatedName) {
		_calculated.setCalculatedName(calculatedName);
	}

	/**
	* Returns the price of this calculated.
	*
	* @return the price of this calculated
	*/
	public double getPrice() {
		return _calculated.getPrice();
	}

	/**
	* Sets the price of this calculated.
	*
	* @param price the price of this calculated
	*/
	public void setPrice(double price) {
		_calculated.setPrice(price);
	}

	/**
	* Returns the percent discount of this calculated.
	*
	* @return the percent discount of this calculated
	*/
	public double getPercentDiscount() {
		return _calculated.getPercentDiscount();
	}

	/**
	* Sets the percent discount of this calculated.
	*
	* @param percentDiscount the percent discount of this calculated
	*/
	public void setPercentDiscount(double percentDiscount) {
		_calculated.setPercentDiscount(percentDiscount);
	}

	/**
	* Returns the percent v a t of this calculated.
	*
	* @return the percent v a t of this calculated
	*/
	public double getPercentVAT() {
		return _calculated.getPercentVAT();
	}

	/**
	* Sets the percent v a t of this calculated.
	*
	* @param percentVAT the percent v a t of this calculated
	*/
	public void setPercentVAT(double percentVAT) {
		_calculated.setPercentVAT(percentVAT);
	}

	public boolean isNew() {
		return _calculated.isNew();
	}

	public void setNew(boolean n) {
		_calculated.setNew(n);
	}

	public boolean isCachedModel() {
		return _calculated.isCachedModel();
	}

	public void setCachedModel(boolean cachedModel) {
		_calculated.setCachedModel(cachedModel);
	}

	public boolean isEscapedModel() {
		return _calculated.isEscapedModel();
	}

	public java.io.Serializable getPrimaryKeyObj() {
		return _calculated.getPrimaryKeyObj();
	}

	public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
		_calculated.setPrimaryKeyObj(primaryKeyObj);
	}

	public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
		return _calculated.getExpandoBridge();
	}

	public void setExpandoBridgeAttributes(
		com.liferay.portal.service.ServiceContext serviceContext) {
		_calculated.setExpandoBridgeAttributes(serviceContext);
	}

	@Override
	public java.lang.Object clone() {
		return new CalculatedWrapper((Calculated)_calculated.clone());
	}

	public int compareTo(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated) {
		return _calculated.compareTo(calculated);
	}

	@Override
	public int hashCode() {
		return _calculated.hashCode();
	}

	public com.liferay.portal.model.CacheModel<org.xmlportletfactory.xmlpf.calculated.model.Calculated> toCacheModel() {
		return _calculated.toCacheModel();
	}

	public org.xmlportletfactory.xmlpf.calculated.model.Calculated toEscapedModel() {
		return new CalculatedWrapper(_calculated.toEscapedModel());
	}

	@Override
	public java.lang.String toString() {
		return _calculated.toString();
	}

	public java.lang.String toXmlString() {
		return _calculated.toXmlString();
	}

	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		_calculated.persist();
	}

	/**
	 * @deprecated Renamed to {@link #getWrappedModel}
	 */
	public Calculated getWrappedCalculated() {
		return _calculated;
	}

	public Calculated getWrappedModel() {
		return _calculated;
	}

	public void resetOriginalValues() {
		_calculated.resetOriginalValues();
	}

	private Calculated _calculated;
}