/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.service;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.InvokableLocalService;

/**
 * The utility for the calculated local service. This utility wraps {@link org.xmlportletfactory.xmlpf.calculated.service.impl.CalculatedLocalServiceImpl} and is the primary access point for service operations in application layer code running on the local server.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author Jack A. Rider
 * @see CalculatedLocalService
 * @see org.xmlportletfactory.xmlpf.calculated.service.base.CalculatedLocalServiceBaseImpl
 * @see org.xmlportletfactory.xmlpf.calculated.service.impl.CalculatedLocalServiceImpl
 * @generated
 */
public class CalculatedLocalServiceUtil {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Add custom service methods to {@link org.xmlportletfactory.xmlpf.calculated.service.impl.CalculatedLocalServiceImpl} and rerun ServiceBuilder to regenerate this class.
	 */

	/**
	* Adds the calculated to the database. Also notifies the appropriate model listeners.
	*
	* @param calculated the calculated
	* @return the calculated that was added
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated addCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().addCalculated(calculated);
	}

	/**
	* Creates a new calculated with the primary key. Does not add the calculated to the database.
	*
	* @param calculatedId the primary key for the new calculated
	* @return the new calculated
	*/
	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated createCalculated(
		long calculatedId) {
		return getService().createCalculated(calculatedId);
	}

	/**
	* Deletes the calculated with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param calculatedId the primary key of the calculated
	* @return the calculated that was removed
	* @throws PortalException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated deleteCalculated(
		long calculatedId)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return getService().deleteCalculated(calculatedId);
	}

	/**
	* Deletes the calculated from the database. Also notifies the appropriate model listeners.
	*
	* @param calculated the calculated
	* @return the calculated that was removed
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated deleteCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().deleteCalculated(calculated);
	}

	public static com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
		return getService().dynamicQuery();
	}

	/**
	* Performs a dynamic query on the database and returns the matching rows.
	*
	* @param dynamicQuery the dynamic query
	* @return the matching rows
	* @throws SystemException if a system exception occurred
	*/
	@SuppressWarnings("rawtypes")
	public static java.util.List dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().dynamicQuery(dynamicQuery);
	}

	/**
	* Performs a dynamic query on the database and returns a range of the matching rows.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param dynamicQuery the dynamic query
	* @param start the lower bound of the range of model instances
	* @param end the upper bound of the range of model instances (not inclusive)
	* @return the range of matching rows
	* @throws SystemException if a system exception occurred
	*/
	@SuppressWarnings("rawtypes")
	public static java.util.List dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end) throws com.liferay.portal.kernel.exception.SystemException {
		return getService().dynamicQuery(dynamicQuery, start, end);
	}

	/**
	* Performs a dynamic query on the database and returns an ordered range of the matching rows.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param dynamicQuery the dynamic query
	* @param start the lower bound of the range of model instances
	* @param end the upper bound of the range of model instances (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching rows
	* @throws SystemException if a system exception occurred
	*/
	@SuppressWarnings("rawtypes")
	public static java.util.List dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService()
				   .dynamicQuery(dynamicQuery, start, end, orderByComparator);
	}

	/**
	* Returns the number of rows that match the dynamic query.
	*
	* @param dynamicQuery the dynamic query
	* @return the number of rows that match the dynamic query
	* @throws SystemException if a system exception occurred
	*/
	public static long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().dynamicQueryCount(dynamicQuery);
	}

	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchCalculated(
		long calculatedId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().fetchCalculated(calculatedId);
	}

	/**
	* Returns the calculated with the primary key.
	*
	* @param calculatedId the primary key of the calculated
	* @return the calculated
	* @throws PortalException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated getCalculated(
		long calculatedId)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return getService().getCalculated(calculatedId);
	}

	public static com.liferay.portal.model.PersistedModel getPersistedModel(
		java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return getService().getPersistedModel(primaryKeyObj);
	}

	/**
	* Returns a range of all the calculateds.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @return the range of calculateds
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> getCalculateds(
		int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().getCalculateds(start, end);
	}

	/**
	* Returns the number of calculateds.
	*
	* @return the number of calculateds
	* @throws SystemException if a system exception occurred
	*/
	public static int getCalculatedsCount()
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().getCalculatedsCount();
	}

	/**
	* Updates the calculated in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	*
	* @param calculated the calculated
	* @return the calculated that was updated
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated updateCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().updateCalculated(calculated);
	}

	/**
	* Updates the calculated in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	*
	* @param calculated the calculated
	* @param merge whether to merge the calculated with the current session. See {@link com.liferay.portal.service.persistence.BatchSession#update(com.liferay.portal.kernel.dao.orm.Session, com.liferay.portal.model.BaseModel, boolean)} for an explanation.
	* @return the calculated that was updated
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated updateCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated,
		boolean merge)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().updateCalculated(calculated, merge);
	}

	/**
	* Returns the Spring bean ID for this bean.
	*
	* @return the Spring bean ID for this bean
	*/
	public static java.lang.String getBeanIdentifier() {
		return getService().getBeanIdentifier();
	}

	/**
	* Sets the Spring bean ID for this bean.
	*
	* @param beanIdentifier the Spring bean ID for this bean
	*/
	public static void setBeanIdentifier(java.lang.String beanIdentifier) {
		getService().setBeanIdentifier(beanIdentifier);
	}

	public static java.lang.Object invokeMethod(java.lang.String name,
		java.lang.String[] parameterTypes, java.lang.Object[] arguments)
		throws java.lang.Throwable {
		return getService().invokeMethod(name, parameterTypes, arguments);
	}

	public static java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> getCompanyEntries(
		long companyId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator obc)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().getCompanyEntries(companyId, start, end, obc);
	}

	public static java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> getCompanyEntries(
		long companyId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().getCompanyEntries(companyId, start, end);
	}

	public static int getCompanyEntriesCount(long companyId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().getCompanyEntriesCount(companyId);
	}

	public static java.util.List findAllInUser(long userId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().findAllInUser(userId);
	}

	public static int countAllInUser(long userId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().countAllInUser(userId);
	}

	public static java.util.List findAllInUser(long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().findAllInUser(userId, orderByComparator);
	}

	public static java.util.List findAllInUser(long userId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().findAllInUser(userId, start, end, orderByComparator);
	}

	public static java.util.List findAllInGroup(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().findAllInGroup(groupId);
	}

	public static int countAllInGroup(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().countAllInGroup(groupId);
	}

	public static java.util.List findAllInGroup(long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().findAllInGroup(groupId, orderByComparator);
	}

	public static java.util.List findAllInGroup(long groupId, int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService()
				   .findAllInGroup(groupId, start, end, orderByComparator);
	}

	public static java.util.List findAllInUserAndGroup(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().findAllInUserAndGroup(userId, groupId);
	}

	public static int countAllInUserAndGroup(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService().countAllInUserAndGroup(userId, groupId);
	}

	public static java.util.List findAllInUserAndGroup(long userId,
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService()
				   .findAllInUserAndGroup(userId, groupId, orderByComparator);
	}

	public static java.util.List findAllInUserAndGroup(long userId,
		long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getService()
				   .findAllInUserAndGroup(userId, groupId, start, end,
			orderByComparator);
	}

	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated addCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated validCalculated,
		com.liferay.portal.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return getService().addCalculated(validCalculated, serviceContext);
	}

	public static org.xmlportletfactory.xmlpf.calculated.model.Calculated updateCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated validCalculated,
		com.liferay.portal.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return getService().updateCalculated(validCalculated, serviceContext);
	}

	public static void deleteCalculatedEntry(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated fileobj)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		getService().deleteCalculatedEntry(fileobj);
	}

	public static void addEntryResources(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated entry,
		boolean addGroupPermissions, boolean addGuestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		getService()
			.addEntryResources(entry, addGroupPermissions, addGuestPermissions);
	}

	public static void addEntryResources(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated entry,
		java.lang.String[] groupPermissions, java.lang.String[] guestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		getService().addEntryResources(entry, groupPermissions, guestPermissions);
	}

	public static void addEntryResources(long entryId,
		boolean addGroupPermissions, boolean addGuestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		getService()
			.addEntryResources(entryId, addGroupPermissions, addGuestPermissions);
	}

	public static void addEntryResources(long entryId,
		java.lang.String[] groupPermissions, java.lang.String[] guestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		getService()
			.addEntryResources(entryId, groupPermissions, guestPermissions);
	}

	public static void updateEntryResources(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated entry,
		java.lang.String[] groupPermissions, java.lang.String[] guestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		getService()
			.updateEntryResources(entry, groupPermissions, guestPermissions);
	}

	public static void clearService() {
		_service = null;
	}

	public static CalculatedLocalService getService() {
		if (_service == null) {
			InvokableLocalService invokableLocalService = (InvokableLocalService)PortletBeanLocatorUtil.locate(ClpSerializer.getServletContextName(),
					CalculatedLocalService.class.getName());

			if (invokableLocalService instanceof CalculatedLocalService) {
				_service = (CalculatedLocalService)invokableLocalService;
			}
			else {
				_service = new CalculatedLocalServiceClp(invokableLocalService);
			}

			ReferenceRegistry.registerReference(CalculatedLocalServiceUtil.class,
				"_service");
		}

		return _service;
	}

	/**
	 * @deprecated
	 */
	public void setService(CalculatedLocalService service) {
	}

	private static CalculatedLocalService _service;
}