/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.service;

import com.liferay.portal.service.ServiceWrapper;

/**
 * <p>
 * This class is a wrapper for {@link CalculatedLocalService}.
 * </p>
 *
 * @author    Jack A. Rider
 * @see       CalculatedLocalService
 * @generated
 */
public class CalculatedLocalServiceWrapper implements CalculatedLocalService,
	ServiceWrapper<CalculatedLocalService> {
	public CalculatedLocalServiceWrapper(
		CalculatedLocalService calculatedLocalService) {
		_calculatedLocalService = calculatedLocalService;
	}

	/**
	* Adds the calculated to the database. Also notifies the appropriate model listeners.
	*
	* @param calculated the calculated
	* @return the calculated that was added
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated addCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.addCalculated(calculated);
	}

	/**
	* Creates a new calculated with the primary key. Does not add the calculated to the database.
	*
	* @param calculatedId the primary key for the new calculated
	* @return the new calculated
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated createCalculated(
		long calculatedId) {
		return _calculatedLocalService.createCalculated(calculatedId);
	}

	/**
	* Deletes the calculated with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param calculatedId the primary key of the calculated
	* @return the calculated that was removed
	* @throws PortalException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated deleteCalculated(
		long calculatedId)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.deleteCalculated(calculatedId);
	}

	/**
	* Deletes the calculated from the database. Also notifies the appropriate model listeners.
	*
	* @param calculated the calculated
	* @return the calculated that was removed
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated deleteCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.deleteCalculated(calculated);
	}

	public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
		return _calculatedLocalService.dynamicQuery();
	}

	/**
	* Performs a dynamic query on the database and returns the matching rows.
	*
	* @param dynamicQuery the dynamic query
	* @return the matching rows
	* @throws SystemException if a system exception occurred
	*/
	@SuppressWarnings("rawtypes")
	public java.util.List dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.dynamicQuery(dynamicQuery);
	}

	/**
	* Performs a dynamic query on the database and returns a range of the matching rows.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param dynamicQuery the dynamic query
	* @param start the lower bound of the range of model instances
	* @param end the upper bound of the range of model instances (not inclusive)
	* @return the range of matching rows
	* @throws SystemException if a system exception occurred
	*/
	@SuppressWarnings("rawtypes")
	public java.util.List dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end) throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.dynamicQuery(dynamicQuery, start, end);
	}

	/**
	* Performs a dynamic query on the database and returns an ordered range of the matching rows.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param dynamicQuery the dynamic query
	* @param start the lower bound of the range of model instances
	* @param end the upper bound of the range of model instances (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching rows
	* @throws SystemException if a system exception occurred
	*/
	@SuppressWarnings("rawtypes")
	public java.util.List dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.dynamicQuery(dynamicQuery, start, end,
			orderByComparator);
	}

	/**
	* Returns the number of rows that match the dynamic query.
	*
	* @param dynamicQuery the dynamic query
	* @return the number of rows that match the dynamic query
	* @throws SystemException if a system exception occurred
	*/
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.dynamicQueryCount(dynamicQuery);
	}

	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchCalculated(
		long calculatedId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.fetchCalculated(calculatedId);
	}

	/**
	* Returns the calculated with the primary key.
	*
	* @param calculatedId the primary key of the calculated
	* @return the calculated
	* @throws PortalException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated getCalculated(
		long calculatedId)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.getCalculated(calculatedId);
	}

	public com.liferay.portal.model.PersistedModel getPersistedModel(
		java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.getPersistedModel(primaryKeyObj);
	}

	/**
	* Returns a range of all the calculateds.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @return the range of calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> getCalculateds(
		int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.getCalculateds(start, end);
	}

	/**
	* Returns the number of calculateds.
	*
	* @return the number of calculateds
	* @throws SystemException if a system exception occurred
	*/
	public int getCalculatedsCount()
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.getCalculatedsCount();
	}

	/**
	* Updates the calculated in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	*
	* @param calculated the calculated
	* @return the calculated that was updated
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated updateCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.updateCalculated(calculated);
	}

	/**
	* Updates the calculated in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	*
	* @param calculated the calculated
	* @param merge whether to merge the calculated with the current session. See {@link com.liferay.portal.service.persistence.BatchSession#update(com.liferay.portal.kernel.dao.orm.Session, com.liferay.portal.model.BaseModel, boolean)} for an explanation.
	* @return the calculated that was updated
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated updateCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated,
		boolean merge)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.updateCalculated(calculated, merge);
	}

	/**
	* Returns the Spring bean ID for this bean.
	*
	* @return the Spring bean ID for this bean
	*/
	public java.lang.String getBeanIdentifier() {
		return _calculatedLocalService.getBeanIdentifier();
	}

	/**
	* Sets the Spring bean ID for this bean.
	*
	* @param beanIdentifier the Spring bean ID for this bean
	*/
	public void setBeanIdentifier(java.lang.String beanIdentifier) {
		_calculatedLocalService.setBeanIdentifier(beanIdentifier);
	}

	public java.lang.Object invokeMethod(java.lang.String name,
		java.lang.String[] parameterTypes, java.lang.Object[] arguments)
		throws java.lang.Throwable {
		return _calculatedLocalService.invokeMethod(name, parameterTypes,
			arguments);
	}

	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> getCompanyEntries(
		long companyId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator obc)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.getCompanyEntries(companyId, start, end,
			obc);
	}

	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> getCompanyEntries(
		long companyId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.getCompanyEntries(companyId, start, end);
	}

	public int getCompanyEntriesCount(long companyId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.getCompanyEntriesCount(companyId);
	}

	public java.util.List findAllInUser(long userId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.findAllInUser(userId);
	}

	public int countAllInUser(long userId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.countAllInUser(userId);
	}

	public java.util.List findAllInUser(long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.findAllInUser(userId, orderByComparator);
	}

	public java.util.List findAllInUser(long userId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.findAllInUser(userId, start, end,
			orderByComparator);
	}

	public java.util.List findAllInGroup(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.findAllInGroup(groupId);
	}

	public int countAllInGroup(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.countAllInGroup(groupId);
	}

	public java.util.List findAllInGroup(long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.findAllInGroup(groupId, orderByComparator);
	}

	public java.util.List findAllInGroup(long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.findAllInGroup(groupId, start, end,
			orderByComparator);
	}

	public java.util.List findAllInUserAndGroup(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.findAllInUserAndGroup(userId, groupId);
	}

	public int countAllInUserAndGroup(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.countAllInUserAndGroup(userId, groupId);
	}

	public java.util.List findAllInUserAndGroup(long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.findAllInUserAndGroup(userId, groupId,
			orderByComparator);
	}

	public java.util.List findAllInUserAndGroup(long userId, long groupId,
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.findAllInUserAndGroup(userId, groupId,
			start, end, orderByComparator);
	}

	public org.xmlportletfactory.xmlpf.calculated.model.Calculated addCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated validCalculated,
		com.liferay.portal.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.addCalculated(validCalculated,
			serviceContext);
	}

	public org.xmlportletfactory.xmlpf.calculated.model.Calculated updateCalculated(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated validCalculated,
		com.liferay.portal.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _calculatedLocalService.updateCalculated(validCalculated,
			serviceContext);
	}

	public void deleteCalculatedEntry(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated fileobj)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_calculatedLocalService.deleteCalculatedEntry(fileobj);
	}

	public void addEntryResources(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated entry,
		boolean addGroupPermissions, boolean addGuestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_calculatedLocalService.addEntryResources(entry, addGroupPermissions,
			addGuestPermissions);
	}

	public void addEntryResources(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated entry,
		java.lang.String[] groupPermissions, java.lang.String[] guestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_calculatedLocalService.addEntryResources(entry, groupPermissions,
			guestPermissions);
	}

	public void addEntryResources(long entryId, boolean addGroupPermissions,
		boolean addGuestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_calculatedLocalService.addEntryResources(entryId, addGroupPermissions,
			addGuestPermissions);
	}

	public void addEntryResources(long entryId,
		java.lang.String[] groupPermissions, java.lang.String[] guestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_calculatedLocalService.addEntryResources(entryId, groupPermissions,
			guestPermissions);
	}

	public void updateEntryResources(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated entry,
		java.lang.String[] groupPermissions, java.lang.String[] guestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_calculatedLocalService.updateEntryResources(entry, groupPermissions,
			guestPermissions);
	}

	/**
	 * @deprecated Renamed to {@link #getWrappedService}
	 */
	public CalculatedLocalService getWrappedCalculatedLocalService() {
		return _calculatedLocalService;
	}

	/**
	 * @deprecated Renamed to {@link #setWrappedService}
	 */
	public void setWrappedCalculatedLocalService(
		CalculatedLocalService calculatedLocalService) {
		_calculatedLocalService = calculatedLocalService;
	}

	public CalculatedLocalService getWrappedService() {
		return _calculatedLocalService;
	}

	public void setWrappedService(CalculatedLocalService calculatedLocalService) {
		_calculatedLocalService = calculatedLocalService;
	}

	private CalculatedLocalService _calculatedLocalService;
}