/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import org.xmlportletfactory.xmlpf.calculated.model.Calculated;

/**
 * The persistence interface for the calculated service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Jack A. Rider
 * @see CalculatedPersistenceImpl
 * @see CalculatedUtil
 * @generated
 */
public interface CalculatedPersistence extends BasePersistence<Calculated> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link CalculatedUtil} to access the calculated persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
	 */

	/**
	* Caches the calculated in the entity cache if it is enabled.
	*
	* @param calculated the calculated
	*/
	public void cacheResult(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated);

	/**
	* Caches the calculateds in the entity cache if it is enabled.
	*
	* @param calculateds the calculateds
	*/
	public void cacheResult(
		java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> calculateds);

	/**
	* Creates a new calculated with the primary key. Does not add the calculated to the database.
	*
	* @param calculatedId the primary key for the new calculated
	* @return the new calculated
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated create(
		long calculatedId);

	/**
	* Removes the calculated with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param calculatedId the primary key of the calculated
	* @return the calculated that was removed
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated remove(
		long calculatedId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	public org.xmlportletfactory.xmlpf.calculated.model.Calculated updateImpl(
		org.xmlportletfactory.xmlpf.calculated.model.Calculated calculated,
		boolean merge)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the calculated with the primary key or throws a {@link org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException} if it could not be found.
	*
	* @param calculatedId the primary key of the calculated
	* @return the calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated findByPrimaryKey(
		long calculatedId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns the calculated with the primary key or returns <code>null</code> if it could not be found.
	*
	* @param calculatedId the primary key of the calculated
	* @return the calculated, or <code>null</code> if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchByPrimaryKey(
		long calculatedId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns all the calculateds where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByGroupId(
		long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the calculateds where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @return the range of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByGroupId(
		long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the calculateds where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByGroupId(
		long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first calculated in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated findByGroupId_First(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns the first calculated in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching calculated, or <code>null</code> if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchByGroupId_First(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last calculated in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated findByGroupId_Last(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns the last calculated in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching calculated, or <code>null</code> if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchByGroupId_Last(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the calculateds before and after the current calculated in the ordered set where groupId = &#63;.
	*
	* @param calculatedId the primary key of the current calculated
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated[] findByGroupId_PrevAndNext(
		long calculatedId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns all the calculateds that the user has permission to view where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the matching calculateds that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> filterFindByGroupId(
		long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the calculateds that the user has permission to view where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @return the range of matching calculateds that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> filterFindByGroupId(
		long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the calculateds that the user has permissions to view where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching calculateds that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> filterFindByGroupId(
		long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the calculateds before and after the current calculated in the ordered set of calculateds that the user has permission to view where groupId = &#63;.
	*
	* @param calculatedId the primary key of the current calculated
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated[] filterFindByGroupId_PrevAndNext(
		long calculatedId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns all the calculateds where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByUserIdGroupId(
		long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the calculateds where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @return the range of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByUserIdGroupId(
		long userId, long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the calculateds where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByUserIdGroupId(
		long userId, long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first calculated in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated findByUserIdGroupId_First(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns the first calculated in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching calculated, or <code>null</code> if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchByUserIdGroupId_First(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last calculated in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated findByUserIdGroupId_Last(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns the last calculated in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching calculated, or <code>null</code> if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchByUserIdGroupId_Last(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the calculateds before and after the current calculated in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param calculatedId the primary key of the current calculated
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated[] findByUserIdGroupId_PrevAndNext(
		long calculatedId, long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns all the calculateds that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the matching calculateds that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> filterFindByUserIdGroupId(
		long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the calculateds that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @return the range of matching calculateds that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> filterFindByUserIdGroupId(
		long userId, long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the calculateds that the user has permissions to view where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching calculateds that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> filterFindByUserIdGroupId(
		long userId, long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the calculateds before and after the current calculated in the ordered set of calculateds that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* @param calculatedId the primary key of the current calculated
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated[] filterFindByUserIdGroupId_PrevAndNext(
		long calculatedId, long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns all the calculateds where userId = &#63;.
	*
	* @param userId the user ID
	* @return the matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByUserId(
		long userId) throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the calculateds where userId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @return the range of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByUserId(
		long userId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the calculateds where userId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByUserId(
		long userId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first calculated in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated findByUserId_First(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns the first calculated in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching calculated, or <code>null</code> if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchByUserId_First(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last calculated in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated findByUserId_Last(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns the last calculated in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching calculated, or <code>null</code> if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchByUserId_Last(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the calculateds before and after the current calculated in the ordered set where userId = &#63;.
	*
	* @param calculatedId the primary key of the current calculated
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated[] findByUserId_PrevAndNext(
		long calculatedId, long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns all the calculateds where companyId = &#63;.
	*
	* @param companyId the company ID
	* @return the matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByCompanyId(
		long companyId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the calculateds where companyId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param companyId the company ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @return the range of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByCompanyId(
		long companyId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the calculateds where companyId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param companyId the company ID
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findByCompanyId(
		long companyId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first calculated in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated findByCompanyId_First(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns the first calculated in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching calculated, or <code>null</code> if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchByCompanyId_First(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last calculated in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated findByCompanyId_Last(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns the last calculated in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching calculated, or <code>null</code> if a matching calculated could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated fetchByCompanyId_Last(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the calculateds before and after the current calculated in the ordered set where companyId = &#63;.
	*
	* @param calculatedId the primary key of the current calculated
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next calculated
	* @throws org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException if a calculated with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.calculated.model.Calculated[] findByCompanyId_PrevAndNext(
		long calculatedId, long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.calculated.NoSuchCalculatedException;

	/**
	* Returns all the calculateds.
	*
	* @return the calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the calculateds.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @return the range of calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findAll(
		int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the calculateds.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param start the lower bound of the range of calculateds
	* @param end the upper bound of the range of calculateds (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of calculateds
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.calculated.model.Calculated> findAll(
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the calculateds where groupId = &#63; from the database.
	*
	* @param groupId the group ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByGroupId(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the calculateds where userId = &#63; and groupId = &#63; from the database.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByUserIdGroupId(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the calculateds where userId = &#63; from the database.
	*
	* @param userId the user ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByUserId(long userId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the calculateds where companyId = &#63; from the database.
	*
	* @param companyId the company ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByCompanyId(long companyId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the calculateds from the database.
	*
	* @throws SystemException if a system exception occurred
	*/
	public void removeAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of calculateds where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the number of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public int countByGroupId(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of calculateds that the user has permission to view where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the number of matching calculateds that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public int filterCountByGroupId(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of calculateds where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the number of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public int countByUserIdGroupId(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of calculateds that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the number of matching calculateds that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public int filterCountByUserIdGroupId(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of calculateds where userId = &#63;.
	*
	* @param userId the user ID
	* @return the number of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public int countByUserId(long userId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of calculateds where companyId = &#63;.
	*
	* @param companyId the company ID
	* @return the number of matching calculateds
	* @throws SystemException if a system exception occurred
	*/
	public int countByCompanyId(long companyId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of calculateds.
	*
	* @return the number of calculateds
	* @throws SystemException if a system exception occurred
	*/
	public int countAll()
		throws com.liferay.portal.kernel.exception.SystemException;
}