/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import org.xmlportletfactory.xmlpf.calculated.model.Calculated;

import java.io.Serializable;

import java.util.Date;

/**
 * The cache model class for representing Calculated in entity cache.
 *
 * @author Jack A. Rider
 * @see Calculated
 * @generated
 */
public class CalculatedCacheModel implements CacheModel<Calculated>,
	Serializable {
	@Override
	public String toString() {
		StringBundler sb = new StringBundler(23);

		sb.append("{calculatedId=");
		sb.append(calculatedId);
		sb.append(", companyId=");
		sb.append(companyId);
		sb.append(", groupId=");
		sb.append(groupId);
		sb.append(", userId=");
		sb.append(userId);
		sb.append(", userName=");
		sb.append(userName);
		sb.append(", createDate=");
		sb.append(createDate);
		sb.append(", modifiedDate=");
		sb.append(modifiedDate);
		sb.append(", calculatedName=");
		sb.append(calculatedName);
		sb.append(", price=");
		sb.append(price);
		sb.append(", percentDiscount=");
		sb.append(percentDiscount);
		sb.append(", percentVAT=");
		sb.append(percentVAT);
		sb.append("}");

		return sb.toString();
	}

	public Calculated toEntityModel() {
		CalculatedImpl calculatedImpl = new CalculatedImpl();

		calculatedImpl.setCalculatedId(calculatedId);
		calculatedImpl.setCompanyId(companyId);
		calculatedImpl.setGroupId(groupId);
		calculatedImpl.setUserId(userId);

		if (userName == null) {
			calculatedImpl.setUserName(StringPool.BLANK);
		}
		else {
			calculatedImpl.setUserName(userName);
		}

		if (createDate == Long.MIN_VALUE) {
			calculatedImpl.setCreateDate(null);
		}
		else {
			calculatedImpl.setCreateDate(new Date(createDate));
		}

		if (modifiedDate == Long.MIN_VALUE) {
			calculatedImpl.setModifiedDate(null);
		}
		else {
			calculatedImpl.setModifiedDate(new Date(modifiedDate));
		}

		if (calculatedName == null) {
			calculatedImpl.setCalculatedName(StringPool.BLANK);
		}
		else {
			calculatedImpl.setCalculatedName(calculatedName);
		}

		calculatedImpl.setPrice(price);
		calculatedImpl.setPercentDiscount(percentDiscount);
		calculatedImpl.setPercentVAT(percentVAT);

		calculatedImpl.resetOriginalValues();

		return calculatedImpl;
	}

	public long calculatedId;
	public long companyId;
	public long groupId;
	public long userId;
	public String userName;
	public long createDate;
	public long modifiedDate;
	public String calculatedName;
	public double price;
	public double percentDiscount;
	public double percentVAT;
}