/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.calculated.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import org.xmlportletfactory.xmlpf.calculated.model.Calculated;
import org.xmlportletfactory.xmlpf.calculated.model.CalculatedModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Calculated service. Represents a row in the &quot;calculated_Calculated&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link org.xmlportletfactory.xmlpf.calculated.model.CalculatedModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CalculatedImpl}.
 * </p>
 *
 * @author Jack A. Rider
 * @see CalculatedImpl
 * @see org.xmlportletfactory.xmlpf.calculated.model.Calculated
 * @see org.xmlportletfactory.xmlpf.calculated.model.CalculatedModel
 * @generated
 */
public class CalculatedModelImpl extends BaseModelImpl<Calculated>
	implements CalculatedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a calculated model instance should use the {@link org.xmlportletfactory.xmlpf.calculated.model.Calculated} interface instead.
	 */
	public static final String TABLE_NAME = "calculated_Calculated";
	public static final Object[][] TABLE_COLUMNS = {
			{ "calculatedId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "calculatedName", Types.VARCHAR },
			{ "price", Types.DOUBLE },
			{ "percentDiscount", Types.DOUBLE },
			{ "percentVAT", Types.DOUBLE }
		};
	public static final String TABLE_SQL_CREATE = "create table calculated_Calculated (calculatedId LONG not null primary key,companyId LONG,groupId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,calculatedName VARCHAR(20) null,price DOUBLE,percentDiscount DOUBLE,percentVAT DOUBLE)";
	public static final String TABLE_SQL_DROP = "drop table calculated_Calculated";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.entity.cache.enabled.org.xmlportletfactory.xmlpf.calculated.model.Calculated"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.finder.cache.enabled.org.xmlportletfactory.xmlpf.calculated.model.Calculated"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.column.bitmask.enabled.org.xmlportletfactory.xmlpf.calculated.model.Calculated"),
			true);
	public static long COMPANYID_COLUMN_BITMASK = 1L;
	public static long GROUPID_COLUMN_BITMASK = 2L;
	public static long USERID_COLUMN_BITMASK = 4L;
	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
				"lock.expiration.time.org.xmlportletfactory.xmlpf.calculated.model.Calculated"));

	public CalculatedModelImpl() {
	}

	public long getPrimaryKey() {
		return _calculatedId;
	}

	public void setPrimaryKey(long primaryKey) {
		setCalculatedId(primaryKey);
	}

	public Serializable getPrimaryKeyObj() {
		return new Long(_calculatedId);
	}

	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	public Class<?> getModelClass() {
		return Calculated.class;
	}

	public String getModelClassName() {
		return Calculated.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("calculatedId", getCalculatedId());
		attributes.put("companyId", getCompanyId());
		attributes.put("groupId", getGroupId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("calculatedName", getCalculatedName());
		attributes.put("price", getPrice());
		attributes.put("percentDiscount", getPercentDiscount());
		attributes.put("percentVAT", getPercentVAT());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long calculatedId = (Long)attributes.get("calculatedId");

		if (calculatedId != null) {
			setCalculatedId(calculatedId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String calculatedName = (String)attributes.get("calculatedName");

		if (calculatedName != null) {
			setCalculatedName(calculatedName);
		}

		Double price = (Double)attributes.get("price");

		if (price != null) {
			setPrice(price);
		}

		Double percentDiscount = (Double)attributes.get("percentDiscount");

		if (percentDiscount != null) {
			setPercentDiscount(percentDiscount);
		}

		Double percentVAT = (Double)attributes.get("percentVAT");

		if (percentVAT != null) {
			setPercentVAT(percentVAT);
		}
	}

	public long getCalculatedId() {
		return _calculatedId;
	}

	public void setCalculatedId(long calculatedId) {
		_calculatedId = calculatedId;
	}

	public long getCompanyId() {
		return _companyId;
	}

	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	public long getGroupId() {
		return _groupId;
	}

	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	public long getUserId() {
		return _userId;
	}

	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	public String getUserUuid() throws SystemException {
		return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
	}

	public void setUserUuid(String userUuid) {
		_userUuid = userUuid;
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	public String getUserName() {
		if (_userName == null) {
			return StringPool.BLANK;
		}
		else {
			return _userName;
		}
	}

	public void setUserName(String userName) {
		_userName = userName;
	}

	public Date getCreateDate() {
		return _createDate;
	}

	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		_modifiedDate = modifiedDate;
	}

	public String getCalculatedName() {
		if (_calculatedName == null) {
			return StringPool.BLANK;
		}
		else {
			return _calculatedName;
		}
	}

	public void setCalculatedName(String calculatedName) {
		_calculatedName = calculatedName;
	}

	public double getPrice() {
		return _price;
	}

	public void setPrice(double price) {
		_price = price;
	}

	public double getPercentDiscount() {
		return _percentDiscount;
	}

	public void setPercentDiscount(double percentDiscount) {
		_percentDiscount = percentDiscount;
	}

	public double getPercentVAT() {
		return _percentVAT;
	}

	public void setPercentVAT(double percentVAT) {
		_percentVAT = percentVAT;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			Calculated.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public Calculated toEscapedModel() {
		if (_escapedModelProxy == null) {
			_escapedModelProxy = (Calculated)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelProxyInterfaces,
					new AutoEscapeBeanHandler(this));
		}

		return _escapedModelProxy;
	}

	@Override
	public Object clone() {
		CalculatedImpl calculatedImpl = new CalculatedImpl();

		calculatedImpl.setCalculatedId(getCalculatedId());
		calculatedImpl.setCompanyId(getCompanyId());
		calculatedImpl.setGroupId(getGroupId());
		calculatedImpl.setUserId(getUserId());
		calculatedImpl.setUserName(getUserName());
		calculatedImpl.setCreateDate(getCreateDate());
		calculatedImpl.setModifiedDate(getModifiedDate());
		calculatedImpl.setCalculatedName(getCalculatedName());
		calculatedImpl.setPrice(getPrice());
		calculatedImpl.setPercentDiscount(getPercentDiscount());
		calculatedImpl.setPercentVAT(getPercentVAT());

		calculatedImpl.resetOriginalValues();

		return calculatedImpl;
	}

	public int compareTo(Calculated calculated) {
		long primaryKey = calculated.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}

		Calculated calculated = null;

		try {
			calculated = (Calculated)obj;
		}
		catch (ClassCastException cce) {
			return false;
		}

		long primaryKey = calculated.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public void resetOriginalValues() {
		CalculatedModelImpl calculatedModelImpl = this;

		calculatedModelImpl._originalCompanyId = calculatedModelImpl._companyId;

		calculatedModelImpl._setOriginalCompanyId = false;

		calculatedModelImpl._originalGroupId = calculatedModelImpl._groupId;

		calculatedModelImpl._setOriginalGroupId = false;

		calculatedModelImpl._originalUserId = calculatedModelImpl._userId;

		calculatedModelImpl._setOriginalUserId = false;

		calculatedModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<Calculated> toCacheModel() {
		CalculatedCacheModel calculatedCacheModel = new CalculatedCacheModel();

		calculatedCacheModel.calculatedId = getCalculatedId();

		calculatedCacheModel.companyId = getCompanyId();

		calculatedCacheModel.groupId = getGroupId();

		calculatedCacheModel.userId = getUserId();

		calculatedCacheModel.userName = getUserName();

		String userName = calculatedCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			calculatedCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			calculatedCacheModel.createDate = createDate.getTime();
		}
		else {
			calculatedCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			calculatedCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			calculatedCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		calculatedCacheModel.calculatedName = getCalculatedName();

		String calculatedName = calculatedCacheModel.calculatedName;

		if ((calculatedName != null) && (calculatedName.length() == 0)) {
			calculatedCacheModel.calculatedName = null;
		}

		calculatedCacheModel.price = getPrice();

		calculatedCacheModel.percentDiscount = getPercentDiscount();

		calculatedCacheModel.percentVAT = getPercentVAT();

		return calculatedCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(23);

		sb.append("{calculatedId=");
		sb.append(getCalculatedId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", calculatedName=");
		sb.append(getCalculatedName());
		sb.append(", price=");
		sb.append(getPrice());
		sb.append(", percentDiscount=");
		sb.append(getPercentDiscount());
		sb.append(", percentVAT=");
		sb.append(getPercentVAT());
		sb.append("}");

		return sb.toString();
	}

	public String toXmlString() {
		StringBundler sb = new StringBundler(37);

		sb.append("<model><model-name>");
		sb.append("org.xmlportletfactory.xmlpf.calculated.model.Calculated");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>calculatedId</column-name><column-value><![CDATA[");
		sb.append(getCalculatedId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>calculatedName</column-name><column-value><![CDATA[");
		sb.append(getCalculatedName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>price</column-name><column-value><![CDATA[");
		sb.append(getPrice());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>percentDiscount</column-name><column-value><![CDATA[");
		sb.append(getPercentDiscount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>percentVAT</column-name><column-value><![CDATA[");
		sb.append(getPercentVAT());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static ClassLoader _classLoader = Calculated.class.getClassLoader();
	private static Class<?>[] _escapedModelProxyInterfaces = new Class[] {
			Calculated.class
		};
	private long _calculatedId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _userId;
	private String _userUuid;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private String _calculatedName;
	private double _price;
	private double _percentDiscount;
	private double _percentVAT;
	private long _columnBitmask;
	private Calculated _escapedModelProxy;
}