<%
/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
%> 
<%@include file="../init.jsp" %>

<%@ page import="org.xmlportletfactory.xmlpf.activities.model.Activities"%>
<%@ page import="org.xmlportletfactory.xmlpf.activities.service.ActivitiesLocalServiceUtil"%>
<%@ page import="org.xmlportletfactory.xmlpf.activities.service.permission.ActivitiesEntryPermission"%>
<%@ page import="com.liferay.portal.kernel.util.HttpUtil"%>
<%@ page import="com.liferay.portal.kernel.language.UnicodeLanguageUtil"%>

<%
ResultRow row = (ResultRow)request.getAttribute(WebKeys.SEARCH_CONTAINER_RESULT_ROW);
Activities activities = (Activities)row.getObject();

long groupId = activities.getGroupId();
String name = Activities.class.getName();
String primKey = String.valueOf(activities.getPrimaryKey());
boolean noDetailsRows = true;

%>
<liferay-ui:icon-menu cssClass="">

	<c:if test="<%= ActivitiesEntryPermission.contains(permissionChecker, activities, ActionKeys.UPDATE) %>">
		<portlet:actionURL name="editActivities" var="editActivitiesURL">
			<portlet:param name="resourcePrimKey" value="<%=primKey %>" />
		</portlet:actionURL>

		<liferay-ui:icon image="edit" url="<%=editActivitiesURL.toString() %>" />
	</c:if>

	<c:if test="<%= ActivitiesEntryPermission.contains (permissionChecker, activities, ActionKeys.DELETE) %>">
		<portlet:actionURL name="deleteActivities" var="deleteActivitiesURL">
			<portlet:param name="resourcePrimKey" value="<%= primKey %>" />
		</portlet:actionURL>
		<c:choose>
			<c:when test="<%= !noDetailsRows %>">
			<%
				String deleteUrl = "javascript:if(confirm('" + UnicodeLanguageUtil.get(pageContext, "confirm-delete") + "')){submitForm(document.hrefFm, '" + HttpUtil.encodeURL(deleteActivitiesURL) + "');}";
			%>
			<liferay-ui:icon image="delete" url="<%=deleteUrl %>" />
			</c:when>
			<c:otherwise>
    		<liferay-ui:icon image="delete" url="<%=deleteActivitiesURL.toString() %>" />

            </c:otherwise>
        </c:choose>
	</c:if>



<c:if test="<%= ActivitiesEntryPermission.contains(permissionChecker, activities, ActionKeys.PERMISSIONS) %>">
		<liferay-security:permissionsURL
			modelResource="org.xmlportletfactory.xmlpf.activities.model.Activities"
			modelResourceDescription="Activities"
			resourcePrimKey="<%= String.valueOf(primKey) %>"
			var="permissionsEntryURL"
		/>

		<liferay-ui:icon
			image="permissions"
			url="<%= permissionsEntryURL %>"
		/>
</c:if>
</liferay-ui:icon-menu>
