/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.activities.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import org.xmlportletfactory.xmlpf.activities.model.Activities;

import java.io.Serializable;

import java.util.Date;

/**
 * The cache model class for representing Activities in entity cache.
 *
 * @author Jack A. Rider
 * @see Activities
 * @generated
 */
public class ActivitiesCacheModel implements CacheModel<Activities>,
	Serializable {
	@Override
	public String toString() {
		StringBundler sb = new StringBundler(17);

		sb.append("{activityId=");
		sb.append(activityId);
		sb.append(", companyId=");
		sb.append(companyId);
		sb.append(", groupId=");
		sb.append(groupId);
		sb.append(", userId=");
		sb.append(userId);
		sb.append(", userName=");
		sb.append(userName);
		sb.append(", createDate=");
		sb.append(createDate);
		sb.append(", modifiedDate=");
		sb.append(modifiedDate);
		sb.append(", activityName=");
		sb.append(activityName);
		sb.append("}");

		return sb.toString();
	}

	public Activities toEntityModel() {
		ActivitiesImpl activitiesImpl = new ActivitiesImpl();

		activitiesImpl.setActivityId(activityId);
		activitiesImpl.setCompanyId(companyId);
		activitiesImpl.setGroupId(groupId);
		activitiesImpl.setUserId(userId);

		if (userName == null) {
			activitiesImpl.setUserName(StringPool.BLANK);
		}
		else {
			activitiesImpl.setUserName(userName);
		}

		if (createDate == Long.MIN_VALUE) {
			activitiesImpl.setCreateDate(null);
		}
		else {
			activitiesImpl.setCreateDate(new Date(createDate));
		}

		if (modifiedDate == Long.MIN_VALUE) {
			activitiesImpl.setModifiedDate(null);
		}
		else {
			activitiesImpl.setModifiedDate(new Date(modifiedDate));
		}

		if (activityName == null) {
			activitiesImpl.setActivityName(StringPool.BLANK);
		}
		else {
			activitiesImpl.setActivityName(activityName);
		}

		activitiesImpl.resetOriginalValues();

		return activitiesImpl;
	}

	public long activityId;
	public long companyId;
	public long groupId;
	public long userId;
	public String userName;
	public long createDate;
	public long modifiedDate;
	public String activityName;
}