/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
 
 
package org.xmlportletfactory.xmlpf.activities.social;

import org.xmlportletfactory.xmlpf.activities.model.Activities;
import org.xmlportletfactory.xmlpf.activities.service.ActivitiesLocalServiceUtil;
import org.xmlportletfactory.xmlpf.activities.service.permission.ActivitiesEntryPermission;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.security.permission.ActionKeys;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;

/**
 * @author Jack A. Rider
 * @author Davide N.P. Rossi.
 */
 
public class ActivitiesActivityInterpreter extends BaseSocialActivityInterpreter {

	public String[] getClassNames() {

        return _CLASS_NAMES;
    }
	
	@Override
    protected SocialActivityFeedEntry doInterpret(
            SocialActivity activity, ThemeDisplay themeDisplay)
        throws Exception {

        PermissionChecker permissionChecker =
            themeDisplay.getPermissionChecker();

        Activities ActivitiesPk =
            ActivitiesLocalServiceUtil.getActivities(
                activity.getClassPK());

        if (!ActivitiesEntryPermission.contains(
		permissionChecker, ActivitiesPk, ActionKeys.VIEW)) {

            return null;
        }
        
        String creatorUserName = getUserName( 
        		activity.getUserId(), themeDisplay);
        
        // Link

        String link = StringPool.BLANK;

        // Title
        
        String title = StringPool.BLANK;

        
        if (activity.getType() == ActivitiesActivityKeys.ADD_ACTIVITIES) {
        	title = themeDisplay.translate(
        		"activity-activities-added-record", 
        		new Object[] {creatorUserName});
        }
        else if (activity.getType() == ActivitiesActivityKeys.UPDATE_ACTIVITIES) {
        	title = themeDisplay.translate(
        		"activity-activities-updated-record", 
        		new Object[] {creatorUserName});
        }

    	// Body

        String body = StringPool.BLANK;

        return new SocialActivityFeedEntry(link, title, body);
    }
	
	private static final String[]_CLASS_NAMES = new String[] {
	    Activities.class.getName()
	};
}
