/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.activities.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Activities service. Represents a row in the &quot;activities_Activities&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link org.xmlportletfactory.xmlpf.activities.model.impl.ActivitiesModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link org.xmlportletfactory.xmlpf.activities.model.impl.ActivitiesImpl}.
 * </p>
 *
 * @author Jack A. Rider
 * @see Activities
 * @see org.xmlportletfactory.xmlpf.activities.model.impl.ActivitiesImpl
 * @see org.xmlportletfactory.xmlpf.activities.model.impl.ActivitiesModelImpl
 * @generated
 */
public interface ActivitiesModel extends BaseModel<Activities>, GroupedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a activities model instance should use the {@link Activities} interface instead.
	 */

	/**
	 * Returns the primary key of this activities.
	 *
	 * @return the primary key of this activities
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this activities.
	 *
	 * @param primaryKey the primary key of this activities
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the activity ID of this activities.
	 *
	 * @return the activity ID of this activities
	 */
	public long getActivityId();

	/**
	 * Sets the activity ID of this activities.
	 *
	 * @param activityId the activity ID of this activities
	 */
	public void setActivityId(long activityId);

	/**
	 * Returns the company ID of this activities.
	 *
	 * @return the company ID of this activities
	 */
	public long getCompanyId();

	/**
	 * Sets the company ID of this activities.
	 *
	 * @param companyId the company ID of this activities
	 */
	public void setCompanyId(long companyId);

	/**
	 * Returns the group ID of this activities.
	 *
	 * @return the group ID of this activities
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this activities.
	 *
	 * @param groupId the group ID of this activities
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the user ID of this activities.
	 *
	 * @return the user ID of this activities
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this activities.
	 *
	 * @param userId the user ID of this activities
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this activities.
	 *
	 * @return the user uuid of this activities
	 * @throws SystemException if a system exception occurred
	 */
	public String getUserUuid() throws SystemException;

	/**
	 * Sets the user uuid of this activities.
	 *
	 * @param userUuid the user uuid of this activities
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this activities.
	 *
	 * @return the user name of this activities
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this activities.
	 *
	 * @param userName the user name of this activities
	 */
	public void setUserName(String userName);

	/**
	 * Returns the create date of this activities.
	 *
	 * @return the create date of this activities
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this activities.
	 *
	 * @param createDate the create date of this activities
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this activities.
	 *
	 * @return the modified date of this activities
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this activities.
	 *
	 * @param modifiedDate the modified date of this activities
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the activity name of this activities.
	 *
	 * @return the activity name of this activities
	 */
	@AutoEscape
	public String getActivityName();

	/**
	 * Sets the activity name of this activities.
	 *
	 * @param activityName the activity name of this activities
	 */
	public void setActivityName(String activityName);

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public Serializable getPrimaryKeyObj();

	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(Activities activities);

	public int hashCode();

	public CacheModel<Activities> toCacheModel();

	public Activities toEscapedModel();

	public String toString();

	public String toXmlString();
}