/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.activities.model;

import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Activities}.
 * </p>
 *
 * @author    Jack A. Rider
 * @see       Activities
 * @generated
 */
public class ActivitiesWrapper implements Activities, ModelWrapper<Activities> {
	public ActivitiesWrapper(Activities activities) {
		_activities = activities;
	}

	public Class<?> getModelClass() {
		return Activities.class;
	}

	public String getModelClassName() {
		return Activities.class.getName();
	}

	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("activityId", getActivityId());
		attributes.put("companyId", getCompanyId());
		attributes.put("groupId", getGroupId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("activityName", getActivityName());

		return attributes;
	}

	public void setModelAttributes(Map<String, Object> attributes) {
		Long activityId = (Long)attributes.get("activityId");

		if (activityId != null) {
			setActivityId(activityId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String activityName = (String)attributes.get("activityName");

		if (activityName != null) {
			setActivityName(activityName);
		}
	}

	/**
	* Returns the primary key of this activities.
	*
	* @return the primary key of this activities
	*/
	public long getPrimaryKey() {
		return _activities.getPrimaryKey();
	}

	/**
	* Sets the primary key of this activities.
	*
	* @param primaryKey the primary key of this activities
	*/
	public void setPrimaryKey(long primaryKey) {
		_activities.setPrimaryKey(primaryKey);
	}

	/**
	* Returns the activity ID of this activities.
	*
	* @return the activity ID of this activities
	*/
	public long getActivityId() {
		return _activities.getActivityId();
	}

	/**
	* Sets the activity ID of this activities.
	*
	* @param activityId the activity ID of this activities
	*/
	public void setActivityId(long activityId) {
		_activities.setActivityId(activityId);
	}

	/**
	* Returns the company ID of this activities.
	*
	* @return the company ID of this activities
	*/
	public long getCompanyId() {
		return _activities.getCompanyId();
	}

	/**
	* Sets the company ID of this activities.
	*
	* @param companyId the company ID of this activities
	*/
	public void setCompanyId(long companyId) {
		_activities.setCompanyId(companyId);
	}

	/**
	* Returns the group ID of this activities.
	*
	* @return the group ID of this activities
	*/
	public long getGroupId() {
		return _activities.getGroupId();
	}

	/**
	* Sets the group ID of this activities.
	*
	* @param groupId the group ID of this activities
	*/
	public void setGroupId(long groupId) {
		_activities.setGroupId(groupId);
	}

	/**
	* Returns the user ID of this activities.
	*
	* @return the user ID of this activities
	*/
	public long getUserId() {
		return _activities.getUserId();
	}

	/**
	* Sets the user ID of this activities.
	*
	* @param userId the user ID of this activities
	*/
	public void setUserId(long userId) {
		_activities.setUserId(userId);
	}

	/**
	* Returns the user uuid of this activities.
	*
	* @return the user uuid of this activities
	* @throws SystemException if a system exception occurred
	*/
	public java.lang.String getUserUuid()
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activities.getUserUuid();
	}

	/**
	* Sets the user uuid of this activities.
	*
	* @param userUuid the user uuid of this activities
	*/
	public void setUserUuid(java.lang.String userUuid) {
		_activities.setUserUuid(userUuid);
	}

	/**
	* Returns the user name of this activities.
	*
	* @return the user name of this activities
	*/
	public java.lang.String getUserName() {
		return _activities.getUserName();
	}

	/**
	* Sets the user name of this activities.
	*
	* @param userName the user name of this activities
	*/
	public void setUserName(java.lang.String userName) {
		_activities.setUserName(userName);
	}

	/**
	* Returns the create date of this activities.
	*
	* @return the create date of this activities
	*/
	public java.util.Date getCreateDate() {
		return _activities.getCreateDate();
	}

	/**
	* Sets the create date of this activities.
	*
	* @param createDate the create date of this activities
	*/
	public void setCreateDate(java.util.Date createDate) {
		_activities.setCreateDate(createDate);
	}

	/**
	* Returns the modified date of this activities.
	*
	* @return the modified date of this activities
	*/
	public java.util.Date getModifiedDate() {
		return _activities.getModifiedDate();
	}

	/**
	* Sets the modified date of this activities.
	*
	* @param modifiedDate the modified date of this activities
	*/
	public void setModifiedDate(java.util.Date modifiedDate) {
		_activities.setModifiedDate(modifiedDate);
	}

	/**
	* Returns the activity name of this activities.
	*
	* @return the activity name of this activities
	*/
	public java.lang.String getActivityName() {
		return _activities.getActivityName();
	}

	/**
	* Sets the activity name of this activities.
	*
	* @param activityName the activity name of this activities
	*/
	public void setActivityName(java.lang.String activityName) {
		_activities.setActivityName(activityName);
	}

	public boolean isNew() {
		return _activities.isNew();
	}

	public void setNew(boolean n) {
		_activities.setNew(n);
	}

	public boolean isCachedModel() {
		return _activities.isCachedModel();
	}

	public void setCachedModel(boolean cachedModel) {
		_activities.setCachedModel(cachedModel);
	}

	public boolean isEscapedModel() {
		return _activities.isEscapedModel();
	}

	public java.io.Serializable getPrimaryKeyObj() {
		return _activities.getPrimaryKeyObj();
	}

	public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
		_activities.setPrimaryKeyObj(primaryKeyObj);
	}

	public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
		return _activities.getExpandoBridge();
	}

	public void setExpandoBridgeAttributes(
		com.liferay.portal.service.ServiceContext serviceContext) {
		_activities.setExpandoBridgeAttributes(serviceContext);
	}

	@Override
	public java.lang.Object clone() {
		return new ActivitiesWrapper((Activities)_activities.clone());
	}

	public int compareTo(Activities activities) {
		return _activities.compareTo(activities);
	}

	@Override
	public int hashCode() {
		return _activities.hashCode();
	}

	public com.liferay.portal.model.CacheModel<Activities> toCacheModel() {
		return _activities.toCacheModel();
	}

	public Activities toEscapedModel() {
		return new ActivitiesWrapper(_activities.toEscapedModel());
	}

	@Override
	public java.lang.String toString() {
		return _activities.toString();
	}

	public java.lang.String toXmlString() {
		return _activities.toXmlString();
	}

	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		_activities.persist();
	}

	/**
	 * @deprecated Renamed to {@link #getWrappedModel}
	 */
	public Activities getWrappedActivities() {
		return _activities;
	}

	public Activities getWrappedModel() {
		return _activities;
	}

	public void resetOriginalValues() {
		_activities.resetOriginalValues();
	}

	private Activities _activities;
}