/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.activities.service;

import com.liferay.portal.service.ServiceWrapper;

/**
 * <p>
 * This class is a wrapper for {@link ActivitiesLocalService}.
 * </p>
 *
 * @author    Jack A. Rider
 * @see       ActivitiesLocalService
 * @generated
 */
public class ActivitiesLocalServiceWrapper implements ActivitiesLocalService,
	ServiceWrapper<ActivitiesLocalService> {
	public ActivitiesLocalServiceWrapper(
		ActivitiesLocalService activitiesLocalService) {
		_activitiesLocalService = activitiesLocalService;
	}

	/**
	* Adds the activities to the database. Also notifies the appropriate model listeners.
	*
	* @param activities the activities
	* @return the activities that was added
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.activities.model.Activities addActivities(
		org.xmlportletfactory.xmlpf.activities.model.Activities activities)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.addActivities(activities);
	}

	/**
	* Creates a new activities with the primary key. Does not add the activities to the database.
	*
	* @param activityId the primary key for the new activities
	* @return the new activities
	*/
	public org.xmlportletfactory.xmlpf.activities.model.Activities createActivities(
		long activityId) {
		return _activitiesLocalService.createActivities(activityId);
	}

	/**
	* Deletes the activities with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param activityId the primary key of the activities
	* @return the activities that was removed
	* @throws PortalException if a activities with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.activities.model.Activities deleteActivities(
		long activityId)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.deleteActivities(activityId);
	}

	/**
	* Deletes the activities from the database. Also notifies the appropriate model listeners.
	*
	* @param activities the activities
	* @return the activities that was removed
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.activities.model.Activities deleteActivities(
		org.xmlportletfactory.xmlpf.activities.model.Activities activities)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.deleteActivities(activities);
	}

	public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
		return _activitiesLocalService.dynamicQuery();
	}

	/**
	* Performs a dynamic query on the database and returns the matching rows.
	*
	* @param dynamicQuery the dynamic query
	* @return the matching rows
	* @throws SystemException if a system exception occurred
	*/
	@SuppressWarnings("rawtypes")
	public java.util.List dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.dynamicQuery(dynamicQuery);
	}

	/**
	* Performs a dynamic query on the database and returns a range of the matching rows.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param dynamicQuery the dynamic query
	* @param start the lower bound of the range of model instances
	* @param end the upper bound of the range of model instances (not inclusive)
	* @return the range of matching rows
	* @throws SystemException if a system exception occurred
	*/
	@SuppressWarnings("rawtypes")
	public java.util.List dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end) throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.dynamicQuery(dynamicQuery, start, end);
	}

	/**
	* Performs a dynamic query on the database and returns an ordered range of the matching rows.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param dynamicQuery the dynamic query
	* @param start the lower bound of the range of model instances
	* @param end the upper bound of the range of model instances (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching rows
	* @throws SystemException if a system exception occurred
	*/
	@SuppressWarnings("rawtypes")
	public java.util.List dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.dynamicQuery(dynamicQuery, start, end,
			orderByComparator);
	}

	/**
	* Returns the number of rows that match the dynamic query.
	*
	* @param dynamicQuery the dynamic query
	* @return the number of rows that match the dynamic query
	* @throws SystemException if a system exception occurred
	*/
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.dynamicQueryCount(dynamicQuery);
	}

	public org.xmlportletfactory.xmlpf.activities.model.Activities fetchActivities(
		long activityId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.fetchActivities(activityId);
	}

	/**
	* Returns the activities with the primary key.
	*
	* @param activityId the primary key of the activities
	* @return the activities
	* @throws PortalException if a activities with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.activities.model.Activities getActivities(
		long activityId)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.getActivities(activityId);
	}

	public com.liferay.portal.model.PersistedModel getPersistedModel(
		java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.getPersistedModel(primaryKeyObj);
	}

	/**
	* Returns a range of all the activitieses.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param start the lower bound of the range of activitieses
	* @param end the upper bound of the range of activitieses (not inclusive)
	* @return the range of activitieses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.activities.model.Activities> getActivitieses(
		int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.getActivitieses(start, end);
	}

	/**
	* Returns the number of activitieses.
	*
	* @return the number of activitieses
	* @throws SystemException if a system exception occurred
	*/
	public int getActivitiesesCount()
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.getActivitiesesCount();
	}

	/**
	* Updates the activities in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	*
	* @param activities the activities
	* @return the activities that was updated
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.activities.model.Activities updateActivities(
		org.xmlportletfactory.xmlpf.activities.model.Activities activities)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.updateActivities(activities);
	}

	/**
	* Updates the activities in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	*
	* @param activities the activities
	* @param merge whether to merge the activities with the current session. See {@link com.liferay.portal.service.persistence.BatchSession#update(com.liferay.portal.kernel.dao.orm.Session, com.liferay.portal.model.BaseModel, boolean)} for an explanation.
	* @return the activities that was updated
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.activities.model.Activities updateActivities(
		org.xmlportletfactory.xmlpf.activities.model.Activities activities,
		boolean merge)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.updateActivities(activities, merge);
	}

	/**
	* Returns the Spring bean ID for this bean.
	*
	* @return the Spring bean ID for this bean
	*/
	public java.lang.String getBeanIdentifier() {
		return _activitiesLocalService.getBeanIdentifier();
	}

	/**
	* Sets the Spring bean ID for this bean.
	*
	* @param beanIdentifier the Spring bean ID for this bean
	*/
	public void setBeanIdentifier(java.lang.String beanIdentifier) {
		_activitiesLocalService.setBeanIdentifier(beanIdentifier);
	}

	public java.lang.Object invokeMethod(java.lang.String name,
		java.lang.String[] parameterTypes, java.lang.Object[] arguments)
		throws java.lang.Throwable {
		return _activitiesLocalService.invokeMethod(name, parameterTypes,
			arguments);
	}

	public java.util.List<org.xmlportletfactory.xmlpf.activities.model.Activities> getCompanyEntries(
		long companyId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator obc)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.getCompanyEntries(companyId, start, end,
			obc);
	}

	public java.util.List<org.xmlportletfactory.xmlpf.activities.model.Activities> getCompanyEntries(
		long companyId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.getCompanyEntries(companyId, start, end);
	}

	public int getCompanyEntriesCount(long companyId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.getCompanyEntriesCount(companyId);
	}

	public java.util.List findAllInUser(long userId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.findAllInUser(userId);
	}

	public int countAllInUser(long userId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.countAllInUser(userId);
	}

	public java.util.List findAllInUser(long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.findAllInUser(userId, orderByComparator);
	}

	public java.util.List findAllInUser(long userId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.findAllInUser(userId, start, end,
			orderByComparator);
	}

	public java.util.List findAllInGroup(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.findAllInGroup(groupId);
	}

	public int countAllInGroup(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.countAllInGroup(groupId);
	}

	public java.util.List findAllInGroup(long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.findAllInGroup(groupId, orderByComparator);
	}

	public java.util.List findAllInGroup(long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.findAllInGroup(groupId, start, end,
			orderByComparator);
	}

	public java.util.List findAllInUserAndGroup(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.findAllInUserAndGroup(userId, groupId);
	}

	public int countAllInUserAndGroup(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.countAllInUserAndGroup(userId, groupId);
	}

	public java.util.List findAllInUserAndGroup(long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.findAllInUserAndGroup(userId, groupId,
			orderByComparator);
	}

	public java.util.List findAllInUserAndGroup(long userId, long groupId,
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.findAllInUserAndGroup(userId, groupId,
			start, end, orderByComparator);
	}

	public org.xmlportletfactory.xmlpf.activities.model.Activities addActivities(
		org.xmlportletfactory.xmlpf.activities.model.Activities validActivities,
		com.liferay.portal.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.addActivities(validActivities,
			serviceContext);
	}

	public org.xmlportletfactory.xmlpf.activities.model.Activities updateActivities(
		org.xmlportletfactory.xmlpf.activities.model.Activities validActivities,
		com.liferay.portal.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		return _activitiesLocalService.updateActivities(validActivities,
			serviceContext);
	}

	public void deleteActivitiesEntry(
		org.xmlportletfactory.xmlpf.activities.model.Activities fileobj)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_activitiesLocalService.deleteActivitiesEntry(fileobj);
	}

	public void addEntryResources(
		org.xmlportletfactory.xmlpf.activities.model.Activities entry,
		boolean addGroupPermissions, boolean addGuestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_activitiesLocalService.addEntryResources(entry, addGroupPermissions,
			addGuestPermissions);
	}

	public void addEntryResources(
		org.xmlportletfactory.xmlpf.activities.model.Activities entry,
		java.lang.String[] groupPermissions, java.lang.String[] guestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_activitiesLocalService.addEntryResources(entry, groupPermissions,
			guestPermissions);
	}

	public void addEntryResources(long entryId, boolean addGroupPermissions,
		boolean addGuestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_activitiesLocalService.addEntryResources(entryId, addGroupPermissions,
			addGuestPermissions);
	}

	public void addEntryResources(long entryId,
		java.lang.String[] groupPermissions, java.lang.String[] guestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_activitiesLocalService.addEntryResources(entryId, groupPermissions,
			guestPermissions);
	}

	public void updateEntryResources(
		org.xmlportletfactory.xmlpf.activities.model.Activities entry,
		java.lang.String[] groupPermissions, java.lang.String[] guestPermissions)
		throws com.liferay.portal.kernel.exception.PortalException,
			com.liferay.portal.kernel.exception.SystemException {
		_activitiesLocalService.updateEntryResources(entry, groupPermissions,
			guestPermissions);
	}

	/**
	 * @deprecated Renamed to {@link #getWrappedService}
	 */
	public ActivitiesLocalService getWrappedActivitiesLocalService() {
		return _activitiesLocalService;
	}

	/**
	 * @deprecated Renamed to {@link #setWrappedService}
	 */
	public void setWrappedActivitiesLocalService(
		ActivitiesLocalService activitiesLocalService) {
		_activitiesLocalService = activitiesLocalService;
	}

	public ActivitiesLocalService getWrappedService() {
		return _activitiesLocalService;
	}

	public void setWrappedService(ActivitiesLocalService activitiesLocalService) {
		_activitiesLocalService = activitiesLocalService;
	}

	private ActivitiesLocalService _activitiesLocalService;
}