/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
 
 
package org.xmlportletfactory.xmlpf.activities;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletURL;
import javax.portlet.ProcessAction;
import javax.portlet.ProcessEvent;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletConfig;
import javax.xml.namespace.QName;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.poi.ss.usermodel.Workbook;
import com.liferay.portal.kernel.servlet.HttpHeaders;

import com.liferay.portal.kernel.dao.search.SearchContainer;

import org.xmlportletfactory.xmlpf.activities.model.Activities;
import org.xmlportletfactory.xmlpf.activities.model.impl.ActivitiesImpl;
import org.xmlportletfactory.xmlpf.activities.service.ActivitiesLocalServiceUtil;
import org.xmlportletfactory.xmlpf.activities.service.permission.ActivitiesPermission;
import org.xmlportletfactory.xmlpf.activities.service.permission.ActivitiesEntryPermission;


import org.xmlportletfactory.xmlpf.activities.util.ActivitiesUtil;

import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.util.JavaConstants;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ActionKeys;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;

/**
 * Portlet implementation class Activities
 */
public class ActivitiesPortlet extends MVCPortlet {



	public void init() throws PortletException {

		// Edit Mode Pages
		editJSP = getInitParameter("edit-jsp");

		// Help Mode Pages
		helpJSP = getInitParameter("help-jsp");

		// View Mode Pages
		viewJSP = getInitParameter("view-jsp");

		// View Mode Edit Activities
		editactivitiesJSP = getInitParameter("edit-activities-jsp");

		// View Mode Entry Activities
		viewactivitiesJSP = getInitParameter("view-activities-jsp");
	}

	protected void include(String path, RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		PortletRequestDispatcher portletRequestDispatcher = getPortletContext()
				.getRequestDispatcher(path);

		if (portletRequestDispatcher == null) {
			// do nothing
			// _log.error(path + " is not a valid include");
		} else {
			portletRequestDispatcher.include(renderRequest, renderResponse);
		}
	}

	public void doView(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		String jsp = (String) renderRequest.getParameter("view");
		if (jsp == null || jsp.equals("")) {
			showViewDefault(renderRequest, renderResponse);
		} else if (jsp.equalsIgnoreCase("editActivities")) {
			try {
				showViewEditActivities(renderRequest, renderResponse);
			} catch (Exception ex) {
				_log.debug(ex);
				try {
					showViewDefault(renderRequest, renderResponse);
				} catch (Exception ex1) {
					_log.debug(ex1);
				}
			}
		}
	}

	public void doEdit(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		showEditDefault(renderRequest, renderResponse);
	}

	public void doHelp(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		include(helpJSP, renderRequest, renderResponse);
	}

	@SuppressWarnings("unchecked")
	public void showViewDefault(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		ThemeDisplay themeDisplay = (ThemeDisplay) renderRequest
				.getAttribute(WebKeys.THEME_DISPLAY);

		long groupId = themeDisplay.getScopeGroupId();

		PermissionChecker permissionChecker = themeDisplay
				.getPermissionChecker();

		boolean hasAddPermission = ActivitiesPermission.contains(permissionChecker, groupId, "ADD_ACTIVITIES");

		boolean hasModelPermissions = ActivitiesPermission.contains(permissionChecker, groupId, ActionKeys.PERMISSIONS);

		List<Activities> tempResults = Collections.EMPTY_LIST;

		PortletPreferences prefs = renderRequest.getPreferences();

		String activitiesFilter = ParamUtil.getString(renderRequest, "activitiesFilter");

		String rowsPerPage = prefs.getValue("rows-per-page","5");

		Integer cur = 1;
		int containerStart = 0;
		int containerEnd = 0;
		String orderByType = renderRequest.getParameter("orderByType");
		String orderByCol = renderRequest.getParameter("orderByCol");
		try{
			cur = ParamUtil.getInteger(renderRequest, "cur");

		}catch (Exception e){
			cur = 1;
		}

		if (cur < 1){
			cur = 1;
		}

		if (Validator.isNotNull(activitiesFilter) || !activitiesFilter.equalsIgnoreCase("")) {
			rowsPerPage = "100";
			cur = 1;
		}

		containerStart = (cur - 1) * Integer.parseInt(rowsPerPage);
		containerEnd = containerStart + Integer.parseInt(rowsPerPage);

		int total = 0;
		try {
			PortalPreferences portalPrefs = PortletPreferencesFactoryUtil.getPortalPreferences(renderRequest);

			if (Validator.isNull(orderByCol) && Validator.isNull(orderByType)) {
				orderByCol = portalPrefs.getValue("Activities_order", "Activities-order-by-col", "activityId");
				orderByType = portalPrefs.getValue("Activities_order", "Activities-order-by-type", "asc");
			}
			OrderByComparator comparator = ActivitiesComparator.getActivitiesOrderByComparator(orderByCol,orderByType);



			if (activitiesFilter.equalsIgnoreCase("")) {
				tempResults = ActivitiesLocalServiceUtil.findAllInGroup(groupId, containerStart, containerEnd, comparator);
				total = ActivitiesLocalServiceUtil.countAllInGroup(groupId);

			} else {

				Indexer indexer = IndexerRegistryUtil.getIndexer(Activities.class);

				SearchContext searchContext = SearchContextFactory.getInstance(PortalUtil.getHttpServletRequest(renderRequest));

				searchContext.setEnd(containerEnd);
				searchContext.setKeywords(activitiesFilter);
				searchContext.setStart(containerStart);

				Hits results = indexer.search(searchContext);

				total = results.getLength();

				if (total > 0) {
					tempResults = new ArrayList<Activities>(total);
				}
				for (int i = 0; i < results.getDocs().length; i++) {
					Document doc = results.doc(i);

					Activities resReg = null;

					// Entry
					long entryId = GetterUtil.getLong(doc.get(Field.ENTRY_CLASS_PK));

					try {
						resReg = ActivitiesLocalServiceUtil.getActivities(entryId);

						resReg = resReg.toEscapedModel();

						tempResults.add(resReg);
					}
					catch (Exception e) {
						if (_log.isWarnEnabled()) {
							_log.warn("Activities search index is stale and contains entry " + entryId);
						}

						continue;
					}
				}
			}

		} catch (Exception e) {
			_log.debug(e);
		}
		renderRequest.setAttribute("highlightRowWithKey", renderRequest.getParameter("highlightRowWithKey"));
		renderRequest.setAttribute("containerStart", containerStart);
		renderRequest.setAttribute("containerEnd", containerEnd);
		renderRequest.setAttribute("cur", cur);
		renderRequest.setAttribute("tempResults", tempResults);
		renderRequest.setAttribute("totalCount", total);
		renderRequest.setAttribute("rowsPerPage", rowsPerPage);
		renderRequest.setAttribute("hasAddPermission", hasAddPermission);
		renderRequest.setAttribute("hasModelPermissions", hasModelPermissions);
		renderRequest.setAttribute("orderByType", orderByType);
		renderRequest.setAttribute("orderByCol", orderByCol);

		PortletURL addActivitiesURL = renderResponse.createActionURL();
		addActivitiesURL.setParameter("javax.portlet.action", "newActivities");
		renderRequest.setAttribute("addActivitiesURL", addActivitiesURL.toString());

		PortletURL activitiesFilterURL = renderResponse.createRenderURL();
		activitiesFilterURL.setParameter("javax.portlet.action", "doView");
		renderRequest.setAttribute("activitiesFilterURL", activitiesFilterURL.toString());

		include(viewJSP, renderRequest, renderResponse);
	}

	public void showViewEditActivities(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
		
		ThemeDisplay themeDisplay = (ThemeDisplay) renderRequest.getAttribute(WebKeys.THEME_DISPLAY);
		PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

		PortletURL editActivitiesURL = renderResponse.createActionURL();
		String editType = (String) renderRequest.getParameter("editType");

		Activities activities = null;
		boolean viewEntryMode=false;
		if (editType.equalsIgnoreCase("edit")) {
			editActivitiesURL.setParameter("javax.portlet.action", "updateActivities");

			long $fname = Long.parseLong(renderRequest.getParameter("activityId"));
			activities = ActivitiesLocalServiceUtil.getActivities($fname);

            	     	renderRequest.setAttribute("activities", activities);
		} else if (editType.equalsIgnoreCase("view")) {

			viewEntryMode= true;

			long $fname = Long.parseLong(renderRequest.getParameter("activityId"));
			activities = ActivitiesLocalServiceUtil.getActivities($fname);


			if (!ActivitiesEntryPermission.contains(
				permissionChecker, activities, ActionKeys.VIEW)){							
				SessionErrors.add(renderRequest, "permission-error");
				return;
	     		}
			
			renderRequest.setAttribute("activities", activities);
		} else {
			editActivitiesURL.setParameter("javax.portlet.action", "addActivities");
			Activities errorActivities = (Activities) renderRequest.getAttribute("errorActivities");
			if (errorActivities != null) {
				if (editType.equalsIgnoreCase("update")) {
					editActivitiesURL.setParameter("javax.portlet.action", "updateActivities");
                		}
				renderRequest.setAttribute("activities", errorActivities);

			} else {				
				
				Activities addActivities = null;


				if (Validator.isNull(renderRequest.getParameter("addErrors"))){
				
					addActivities = new ActivitiesImpl();
					addActivities.setActivityId(0);
					addActivities.setActivityName("");
				}else{
					addActivities = ActivitiesFromRequest(renderRequest);
				}
				renderRequest.setAttribute("activities", addActivities);
			}

		}		

		if (!viewEntryMode){
			renderRequest.setAttribute("editActivitiesURL", editActivitiesURL.toString());		
			include(editactivitiesJSP, renderRequest, renderResponse);
		}else{
			include(viewactivitiesJSP, renderRequest, renderResponse);
		}
	}

	private String dateToJsp(ActionRequest request, Date date) {
		PortletPreferences prefs = request.getPreferences();
		return dateToJsp(prefs, date);
	}
	private String dateToJsp(RenderRequest request, Date date) {
		PortletPreferences prefs = request.getPreferences();
		return dateToJsp(prefs, date);
	}
	private String dateToJsp(PortletPreferences prefs, Date date) {
		SimpleDateFormat format = new SimpleDateFormat(prefs.getValue("date-format", "yyyy/MM/dd"));
		String stringDate = format.format(date);
		return stringDate;
	}
	private String dateTimeToJsp(Date date) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
		String stringDate = format.format(date);
		return stringDate;
	}

	public void showEditDefault(RenderRequest renderRequest,
			RenderResponse renderResponse) throws PortletException, IOException {

		include(editJSP, renderRequest, renderResponse);
	}

	/* Portlet Actions */

	@ProcessAction(name = "newActivities")
	public void newActivities(ActionRequest request, ActionResponse response) throws Exception{
		ActivitiesUtil.addParametersForAdd(response);
	}

	@ProcessAction(name = "addActivities")
	public void addActivities(ActionRequest request, ActionResponse response) throws Exception {
            Activities activities = ActivitiesFromRequest(request);
	    ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
	    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

	    if (!ActivitiesPermission.contains(
					permissionChecker, themeDisplay.getScopeGroupId(), "ADD_ACTIVITIES")){	
				ActivitiesUtil.addParametersForDefaultView(response);						
				SessionErrors.add(request, "permission-error");
				return;
	    }
            ArrayList<String> errors = ActivitiesValidator.validateActivities(activities, request);

            if (errors.isEmpty()) {
		try {
			ServiceContext serviceContext = ServiceContextFactory.getInstance(Activities.class.getName(), request);
			ActivitiesLocalServiceUtil.addActivities(activities, serviceContext);

			ActivitiesUtil.addParametersForDefaultView(response);
                	SessionMessages.add(request, "activities-added-successfully");

            	} catch (Exception cvex) {
            		SessionErrors.add(request, "please-enter-a-unique-code");
			PortalUtil.copyRequestParameters(request, response);			
			ActivitiesUtil.addParametersForAddWithErrors(response);		
            	}
            } else {
                for (String error : errors) {
                        SessionErrors.add(request, error);
                }
		PortalUtil.copyRequestParameters(request, response);			
		ActivitiesUtil.addParametersForAddWithErrors(response);	
            }
	}

	@ProcessAction(name = "eventActivities")
	public void eventActivities(ActionRequest request, ActionResponse response)
			throws Exception {
		long key = ParamUtil.getLong(request, "resourcePrimKey");
		int containerStart = ParamUtil.getInteger(request, "containerStart");
		int containerEnd = ParamUtil.getInteger(request, "containerEnd");
		int cur = ParamUtil.getInteger(request, "cur");
		String orderByType = ParamUtil.getString(request, "orderByType");
		String orderByCol = ParamUtil.getString(request, "orderByCol");
		String activitiesFilter = ParamUtil.getString(request, "ActivitiesFilter");
		if (Validator.isNotNull(key)) {
            		response.setRenderParameter("highlightRowWithKey", Long.toString(key));
            		response.setRenderParameter("containerStart", Integer.toString(containerStart));
            		response.setRenderParameter("containerEnd", Integer.toString(containerEnd));
			response.setRenderParameter("cur", Integer.toString(cur));
			response.setRenderParameter("orderByType", orderByType);
			response.setRenderParameter("orderByCol", orderByCol);
			response.setRenderParameter("ActivitiesFilter", activitiesFilter);
		}
	}

	@ProcessAction(name = "editActivities")
	public void editActivities(ActionRequest request, ActionResponse response)
			throws Exception {
		long key = ParamUtil.getLong(request, "resourcePrimKey");
		if (Validator.isNotNull(key)) {
			ActivitiesUtil.addParametersForEdit(response, key);
			
		}
	}

	@ProcessAction(name = "deleteActivities")
	public void deleteActivities(ActionRequest request, ActionResponse response)throws Exception {		

		long id = ParamUtil.getLong(request, "resourcePrimKey");

		if (Validator.isNotNull(id)) {
			ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
			PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

			if (!ActivitiesEntryPermission.contains(
					permissionChecker, id, ActionKeys.DELETE)){	
				ActivitiesUtil.addParametersForDefaultView(response);						
				SessionErrors.add(request, "permission-error");
				return;
			}

			Activities activities = ActivitiesLocalServiceUtil.getActivities(id);
			ActivitiesLocalServiceUtil.deleteActivitiesEntry(activities);
			SessionMessages.add(request, "activities-deleted-successfully");
            		response.setRenderParameter("activityId", "0");
		} else {
			SessionErrors.add(request, "activities-error-deleting");
		}
	}

	@ProcessAction(name = "updateActivities")
	public void updateActivities(ActionRequest request, ActionResponse response) throws Exception {
            Activities activities = ActivitiesFromRequest(request);
	    ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
	    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

	    if (!ActivitiesEntryPermission.contains(
				permissionChecker, activities, ActionKeys.UPDATE)){	
				ActivitiesUtil.addParametersForDefaultView(response);						
				SessionErrors.add(request, "permission-error");
				return;
	     }

            ArrayList<String> errors = ActivitiesValidator.validateActivities(activities, request);

            if (errors.isEmpty()) {
            	try {
			ServiceContext serviceContext = ServiceContextFactory.getInstance(Activities.class.getName(), request);
                	ActivitiesLocalServiceUtil.updateActivities(activities, serviceContext);

			ActivitiesUtil.addParametersForDefaultView(response);
                	SessionMessages.add(request, "activities-updated-successfully");

            	} catch (Exception cvex) {
            	    SessionErrors.add(request, "please-enter-a-unique-code");
		    		ActivitiesUtil.addParametersForEdit(response, null);
					request.setAttribute("activities",activities);
            	}
            } else {
                for (String error : errors) {
                        SessionErrors.add(request, error);
                }
				ActivitiesUtil.addParametersForEdit(response, Long.toString(activities.getPrimaryKey()));
				request.setAttribute("activities",activities);
            }
        }

	@ProcessAction(name = "setActivitiesPref")
	public void setActivitiesPref(ActionRequest request, ActionResponse response) throws Exception {

		String rowsPerPage = ParamUtil.getString(request, "rows-per-page");
		String dateFormat = ParamUtil.getString(request, "date-format");
		String datetimeFormat = ParamUtil.getString(request, "datetime-format");

		ArrayList<String> errors = new ArrayList();
		if (ActivitiesValidator.validateEditActivities(rowsPerPage, dateFormat, datetimeFormat, errors)) {
			response.setRenderParameter("rows-per-page", "");
			response.setRenderParameter("date-format", "");
			response.setRenderParameter("datetime-format", "");

			PortletPreferences prefs = request.getPreferences();
			prefs.setValue("rows-per-page", rowsPerPage);
			prefs.setValue("date-format", dateFormat);
			prefs.setValue("datetime-format", datetimeFormat);
			prefs.store();

			SessionMessages.add(request, "prefs-success");
		}
	}

	private Activities ActivitiesFromRequest(PortletRequest request) {
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
		ActivitiesImpl activities = new ActivitiesImpl();
        	try {
            		activities.setActivityId(ParamUtil.getLong(request, "activityId"));
        	} catch (Exception nfe) {
		    //Controled en Validator
        	}
		activities.setActivityName(ParamUtil.getString(request, "activityName"));
		try {
		    	activities.setPrimaryKey(ParamUtil.getLong(request,"resourcePrimKey"));
		} catch (NumberFormatException nfe) {
			//Controled en Validator
        	}

		activities.setCompanyId(themeDisplay.getCompanyId());
		activities.setGroupId(themeDisplay.getScopeGroupId());
		activities.setUserId(themeDisplay.getUserId());
		return activities;
	}



	public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
		resourceResponse.setContentType("text/javascript");
		String resourceId = resourceRequest.getResourceID();

		if (Validator.isNotNull(resourceId) && resourceId.length() != 0) {

			if(resourceId.equalsIgnoreCase("exportFullActivitiesResourceURL")) {

		    		ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute(WebKeys.THEME_DISPLAY);
		    		Locale locale = themeDisplay.getLocale();
		    		PortletConfig portletConfig = (PortletConfig)resourceRequest.getAttribute(JavaConstants.JAVAX_PORTLET_CONFIG);

		    		resourceResponse.setContentType("application/vnd.ms-excel");
		    		resourceResponse.setProperty("expires","-1d");
		    		resourceResponse.setProperty("Pragma","no-cache");
		    		resourceResponse.setProperty("Cache-control","no-cache");
				resourceResponse.addProperty(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\" Activities\"");

				try {
					Workbook book = ActivitiesExporter.generateFullExcel(themeDisplay.getScopeGroupId(), portletConfig, locale);
					OutputStream out = resourceResponse.getPortletOutputStream();
					book.write(out);
					out.flush();
					out.close();
				} catch (SystemException e) {
					e.printStackTrace();
					throw new PortletException("Export Excel Error",e);
				}
			}

		}
	}

	protected String editactivitiesJSP;
	protected String editJSP;
	protected String helpJSP;
	protected String viewJSP;
	protected String viewactivitiesJSP;

	private static Log _log = LogFactoryUtil.getLog(ActivitiesPortlet.class);

}