/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
 
 package org.xmlportletfactory.xmlpf.activities.service.impl;

import java.util.List;

import org.xmlportletfactory.xmlpf.activities.NoSuchActivitiesException;
import org.xmlportletfactory.xmlpf.activities.model.Activities;
import org.xmlportletfactory.xmlpf.activities.service.base.ActivitiesLocalServiceBaseImpl;
import org.xmlportletfactory.xmlpf.activities.social.ActivitiesActivityKeys;
import org.xmlportletfactory.xmlpf.activities.util.ActivitiesIndexer;
import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.model.ResourceConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.Date;


/**
 * @author Jack A. Rider
 * @author Juan Gonzalez P.
 */
public class ActivitiesLocalServiceImpl extends ActivitiesLocalServiceBaseImpl {

	@SuppressWarnings("unchecked")
	public List<Activities> getCompanyEntries(
			long companyId, int start, int end,
			OrderByComparator obc)
		throws SystemException {

		return activitiesPersistence.findByCompanyId(
				companyId, start, end, obc);
	}

	@SuppressWarnings("unchecked")
	public List<Activities> getCompanyEntries(
			long companyId, int start, int end)
		throws SystemException {

		return activitiesPersistence.findByCompanyId(
				companyId, start, end);
	}

	@SuppressWarnings("unchecked")
	public int getCompanyEntriesCount(
			long companyId)
		throws SystemException {

		return activitiesPersistence.countByCompanyId(companyId);
	}

	@SuppressWarnings("unchecked")
	public List findAllInUser(long userId)throws SystemException {
		List<Activities> list = (List<Activities>) activitiesPersistence.findByUserId(userId);
		return list;
	}

	@SuppressWarnings("unchecked")
	public int countAllInUser(long userId)throws SystemException {
		int count = activitiesPersistence.countByUserId(userId);
		return count;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUser(long userId, OrderByComparator orderByComparator) throws SystemException {

		List<Activities> list = (List<Activities>) findAllInUser(userId, QueryUtil.ALL_POS,QueryUtil.ALL_POS, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUser(long userId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
		List<Activities> list = (List<Activities>) activitiesPersistence.findByUserId(userId, start, end, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInGroup(long groupId) throws SystemException {
		List<Activities> list = (List<Activities>) activitiesPersistence.filterFindByGroupId(groupId);
		return list;
	}

	@SuppressWarnings("unchecked")
	public int countAllInGroup(long groupId) throws SystemException {
		int count = activitiesPersistence.filterCountByGroupId(groupId);
		return count;
	}

	@SuppressWarnings("unchecked")
	public List findAllInGroup(long groupId, OrderByComparator orderByComparator) throws SystemException{
		List <Activities> list = (List<Activities>) findAllInGroup (groupId, QueryUtil.ALL_POS,QueryUtil.ALL_POS, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInGroup(long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException{
		List <Activities> list = (List<Activities>) activitiesPersistence.filterFindByGroupId(groupId, start, end, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUserAndGroup(long userId, long groupId) throws SystemException {
		List<Activities> list = (List<Activities>) activitiesPersistence.filterFindByUserIdGroupId(userId, groupId);
		return list;
	}

	@SuppressWarnings("unchecked")
	public int countAllInUserAndGroup(long userId, long groupId) throws SystemException {
		int count = activitiesPersistence.filterCountByUserIdGroupId(userId, groupId);
		return count;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUserAndGroup(long userId, long groupId, OrderByComparator orderByComparator) throws SystemException {

		List<Activities> list = (List<Activities>) findAllInUserAndGroup(groupId, userId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUserAndGroup(long userId, long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
		List<Activities> list = (List<Activities>) activitiesPersistence.filterFindByUserIdGroupId(userId, groupId, start, end, orderByComparator);
		return list;
	}




	public Activities addActivities (Activities validActivities, ServiceContext serviceContext) throws PortalException, SystemException {
	    Activities retVal = _addActivities (validActivities, serviceContext);

		// Resources
		if (serviceContext.isAddGroupPermissions() ||
			serviceContext.isAddGuestPermissions()) {

			addEntryResources(
				retVal, serviceContext.isAddGroupPermissions(),
				serviceContext.isAddGuestPermissions());
		}
		else {
			addEntryResources(
				retVal, serviceContext.getGroupPermissions(),
				serviceContext.getGuestPermissions());
		}

		// Social
	    
	 	socialActivityLocalService.addActivity(
				retVal.getUserId(), retVal.getGroupId(),
				Activities.class.getName(), retVal.getPrimaryKey(),
				ActivitiesActivityKeys.ADD_ACTIVITIES, 
				StringPool.BLANK, 0);
		

		// Indexer

		Indexer indexer = IndexerRegistryUtil.getIndexer(Activities.class);

		indexer.reindex(retVal);
		return retVal;
	}

	public Activities updateActivities (Activities validActivities, ServiceContext serviceContext) throws PortalException, SystemException {
	
		Activities entry = activitiesPersistence.findByPrimaryKey(validActivities.getPrimaryKey());
		validActivities.setCreateDate(entry.getCreateDate());	

		validActivities.setModifiedDate(serviceContext.getModifiedDate(null));
	
		// Social
		
		socialActivityLocalService.addActivity(
			validActivities.getUserId(), validActivities.getGroupId(),
				Activities.class.getName(), validActivities.getPrimaryKey(),
				ActivitiesActivityKeys.UPDATE_ACTIVITIES, StringPool.BLANK, 0);

		Activities retVal = activitiesPersistence.update(validActivities, false);

		// Resources

		if ((serviceContext.getGroupPermissions() != null) ||
				(serviceContext.getGuestPermissions() != null)) {

			updateEntryResources(
				retVal, serviceContext.getGroupPermissions(),
				serviceContext.getGuestPermissions());
		}

		// Indexer

		Indexer indexer = IndexerRegistryUtil.getIndexer(Activities.class);

		indexer.reindex(retVal);

		return retVal;
	}

	private Activities _addActivities (Activities validActivities, ServiceContext serviceContext) throws PortalException, SystemException {
		Activities fileobj = activitiesPersistence.create(counterLocalService.increment(Activities.class.getName()));

	     	User user = userPersistence.findByPrimaryKey(validActivities.getUserId());

	     	Date now =new Date();
	    	fileobj.setCompanyId(validActivities.getCompanyId());
	    	fileobj.setGroupId(validActivities.getGroupId());
	    	fileobj.setUserId(user.getUserId());
	    	fileobj.setUserName(user.getFullName());
	    	fileobj.setCreateDate(now);
	    	fileobj.setModifiedDate(now);


	    	fileobj.setActivityName(validActivities.getActivityName());

	 		return activitiesPersistence.update(fileobj, false);
	}

	public void deleteActivitiesEntry (Activities fileobj) throws PortalException, SystemException {

		activitiesPersistence.remove(fileobj.getPrimaryKey());

		// Resources

		resourceLocalService.deleteResource(
			fileobj.getCompanyId(), Activities.class.getName(),
			ResourceConstants.SCOPE_INDIVIDUAL, fileobj.getPrimaryKey());


		// Social
		
		socialActivityLocalService.deleteActivities(
			Activities.class.getName(), fileobj.getPrimaryKey()); 	

		// Indexer

		Indexer indexer = IndexerRegistryUtil.getIndexer(Activities.class);

		indexer.delete(fileobj);


	}



	public void addEntryResources(
			Activities entry, boolean addGroupPermissions,
			boolean addGuestPermissions)
		throws PortalException, SystemException {

		resourceLocalService.addResources(
			entry.getCompanyId(), entry.getGroupId(), entry.getUserId(),
			Activities.class.getName(), entry.getPrimaryKey(), false,
			addGroupPermissions, addGuestPermissions);
	}

	public void addEntryResources(
			Activities entry, String[] groupPermissions,
			String[] guestPermissions)
		throws PortalException, SystemException {

		resourceLocalService.addModelResources(
			entry.getCompanyId(), entry.getGroupId(), entry.getUserId(),
			Activities.class.getName(), entry.getPrimaryKey(), groupPermissions,
			guestPermissions);
	}

	public void addEntryResources(
			long entryId, boolean addGroupPermissions,
			boolean addGuestPermissions)
		throws PortalException, SystemException {

		Activities entry = activitiesPersistence.findByPrimaryKey(entryId);

		addEntryResources(entry, addGroupPermissions, addGuestPermissions);
	}

	public void addEntryResources(
			long entryId, String[] groupPermissions, String[] guestPermissions)
		throws PortalException, SystemException {

		Activities entry = activitiesPersistence.findByPrimaryKey(entryId);

		addEntryResources(entry, groupPermissions, guestPermissions);
	}

	public void updateEntryResources(
			Activities entry, String[] groupPermissions,
			String[] guestPermissions)
		throws PortalException, SystemException {

		resourceLocalService.updateResources(
			entry.getCompanyId(), entry.getGroupId(),
			Activities.class.getName(), entry.getPrimaryKey(), groupPermissions,
			guestPermissions);
	}
}
