<%
/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
%> 
<%@include file="../init.jsp" %>

<%@ page import="org.xmlportletfactory.xmlpf.assetsintegration.model.Products"%>
<%@ page import="org.xmlportletfactory.xmlpf.assetsintegration.service.ProductsLocalServiceUtil"%>
<%@ page import="org.xmlportletfactory.xmlpf.assetsintegration.service.permission.ProductsEntryPermission"%>
<%@ page import="com.liferay.portal.kernel.util.HttpUtil"%>
<%@ page import="com.liferay.portal.kernel.language.UnicodeLanguageUtil"%>

<%
ResultRow row = (ResultRow)request.getAttribute(WebKeys.SEARCH_CONTAINER_RESULT_ROW);
Products products = (Products)row.getObject();

long groupId = products.getGroupId();
String name = Products.class.getName();
String primKey = String.valueOf(products.getPrimaryKey());
boolean noDetailsRows = true;

%>
<liferay-ui:icon-menu cssClass="">

	<c:if test="<%= ProductsEntryPermission.contains(permissionChecker, products, ActionKeys.UPDATE) %>">
		<portlet:actionURL name="editProducts" var="editProductsURL">
			<portlet:param name="resourcePrimKey" value="<%=primKey %>" />
		</portlet:actionURL>

		<liferay-ui:icon image="edit" url="<%=editProductsURL.toString() %>" />
	</c:if>

	<c:if test="<%= ProductsEntryPermission.contains (permissionChecker, products, ActionKeys.DELETE) %>">
		<portlet:actionURL name="deleteProducts" var="deleteProductsURL">
			<portlet:param name="resourcePrimKey" value="<%= primKey %>" />
		</portlet:actionURL>
		<c:choose>
			<c:when test="<%= !noDetailsRows %>">
			<%
				String deleteUrl = "javascript:if(confirm('" + UnicodeLanguageUtil.get(pageContext, "confirm-delete") + "')){submitForm(document.hrefFm, '" + HttpUtil.encodeURL(deleteProductsURL) + "');}";
			%>
			<liferay-ui:icon image="delete" url="<%=deleteUrl %>" />
			</c:when>
			<c:otherwise>
    		<liferay-ui:icon image="delete" url="<%=deleteProductsURL.toString() %>" />

            </c:otherwise>
        </c:choose>
	</c:if>



<c:if test="<%= ProductsEntryPermission.contains(permissionChecker, products, ActionKeys.PERMISSIONS) %>">
		<liferay-security:permissionsURL
			modelResource="org.xmlportletfactory.xmlpf.assetsintegration.model.Products"
			modelResourceDescription="Products"
			resourcePrimKey="<%= String.valueOf(primKey) %>"
			var="permissionsEntryURL"
		/>

		<liferay-ui:icon
			image="permissions"
			url="<%= permissionsEntryURL %>"
		/>
</c:if>
</liferay-ui:icon-menu>
