<%
/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
%> 
<%@include file="../init.jsp" %>
<%@ page import="org.xmlportletfactory.xmlpf.assetsintegration.model.Products" %>
<%@ page import="com.liferay.portal.kernel.util.StringPool" %>
<%@ page import="com.liferay.portal.kernel.util.HttpUtil" %>
<%@ page import="com.liferay.portal.kernel.util.HtmlUtil" %>
<%@ page import="javax.script.ScriptEngine" %>
<%@ page import="javax.script.ScriptEngineManager" %>	
<%@ page import="java.lang.Boolean" %>


<jsp:useBean class="java.lang.String" id="editProductsURL" scope="request" />
<jsp:useBean id="products" type="org.xmlportletfactory.xmlpf.assetsintegration.model.Products" scope="request"/>


<portlet:defineObjects />

<% boolean fromAsset = (request.getAttribute("fromAsset") !=null ? (Boolean) request.getAttribute("fromAsset"): false); %>


<portlet:renderURL var="redirect"></portlet:renderURL>

<div class="entry">




			<span class="aui-field-content">
				<label class="aui-field-label"> 
					<liferay-ui:message key="products-productname" />
				</label>
				<span class="aui-field-element">
					<%= products.getProductName() %>
				</span>
			</span>

			<span class="aui-field-content">
				<label class="aui-field-label"> 
					<liferay-ui:message key="products-productdescription" />
				</label>
				<span class="aui-field-element">
					<%= products.getProductDescription() %>
				</span>
			</span>


		<liferay-ui:ratings className="<%= Products.class.getName() %>"
    				classPK="<%= products.getPrimaryKey() %>" type="stars" />
			
		<liferay-ui:asset-categories-summary className="<%=Products.class.getName() %>" classPK="<%=products.getPrimaryKey() %>" />	
		<liferay-ui:asset-tags-summary className="<%=Products.class.getName() %>" classPK="<%=products.getPrimaryKey() %>" />	

	
		<liferay-ui:panel-container extended="<%= false %>"
					id="ProductsCommentsPanelContainer" persistState="<%= true %>">
	
					<liferay-ui:panel collapsible="<%= true %>" extended="<%= true %>" id="ProductsCommentsPanel" persistState="<%= true %>"
	        				title='<%= LanguageUtil.get(pageContext, "comments") %>'>
	
						<portlet:actionURL name="invokeTaglibDiscussion" var="discussionURL" />
	
						<liferay-ui:discussion className="<%= Products.class.getName() %>"
	            				classPK="<%= products.getPrimaryKey() %>"
	            				formAction="<%= discussionURL %>" formName="ProductsCommentsForm"
	            				ratingsEnabled="<%= true %>" redirect="<%= redirect %>"
	            				subject="<%= products.getProductName() %>"
	            				userId="<%= products.getUserId() %>" />
	
					</liferay-ui:panel>
	
		</liferay-ui:panel-container>		
	
		<liferay-ui:panel defaultState="closed" extended="<%= false %>" 
					id="ProductsEntryAssetLinksPanel" persistState="<%= true %>" title="related-assets">
					<aui:fieldset>
						<liferay-ui:input-asset-links className="<%= Products.class.getName() %>" classPK="<%= products.getPrimaryKey() %>"/>
					</aui:fieldset>
		</liferay-ui:panel>		


</div>
