/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.assetsintegration.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Products service. Represents a row in the &quot;assetsintegration_Products&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link org.xmlportletfactory.xmlpf.assetsintegration.model.impl.ProductsModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link org.xmlportletfactory.xmlpf.assetsintegration.model.impl.ProductsImpl}.
 * </p>
 *
 * @author Jack A. Rider
 * @see Products
 * @see org.xmlportletfactory.xmlpf.assetsintegration.model.impl.ProductsImpl
 * @see org.xmlportletfactory.xmlpf.assetsintegration.model.impl.ProductsModelImpl
 * @generated
 */
public interface ProductsModel extends BaseModel<Products>, GroupedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a products model instance should use the {@link Products} interface instead.
	 */

	/**
	 * Returns the primary key of this products.
	 *
	 * @return the primary key of this products
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this products.
	 *
	 * @param primaryKey the primary key of this products
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this products.
	 *
	 * @return the uuid of this products
	 */
	@AutoEscape
	public String getUuid();

	/**
	 * Sets the uuid of this products.
	 *
	 * @param uuid the uuid of this products
	 */
	public void setUuid(String uuid);

	/**
	 * Returns the product ID of this products.
	 *
	 * @return the product ID of this products
	 */
	public long getProductId();

	/**
	 * Sets the product ID of this products.
	 *
	 * @param productId the product ID of this products
	 */
	public void setProductId(long productId);

	/**
	 * Returns the company ID of this products.
	 *
	 * @return the company ID of this products
	 */
	public long getCompanyId();

	/**
	 * Sets the company ID of this products.
	 *
	 * @param companyId the company ID of this products
	 */
	public void setCompanyId(long companyId);

	/**
	 * Returns the group ID of this products.
	 *
	 * @return the group ID of this products
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this products.
	 *
	 * @param groupId the group ID of this products
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the user ID of this products.
	 *
	 * @return the user ID of this products
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this products.
	 *
	 * @param userId the user ID of this products
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this products.
	 *
	 * @return the user uuid of this products
	 * @throws SystemException if a system exception occurred
	 */
	public String getUserUuid() throws SystemException;

	/**
	 * Sets the user uuid of this products.
	 *
	 * @param userUuid the user uuid of this products
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this products.
	 *
	 * @return the user name of this products
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this products.
	 *
	 * @param userName the user name of this products
	 */
	public void setUserName(String userName);

	/**
	 * Returns the create date of this products.
	 *
	 * @return the create date of this products
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this products.
	 *
	 * @param createDate the create date of this products
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this products.
	 *
	 * @return the modified date of this products
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this products.
	 *
	 * @param modifiedDate the modified date of this products
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the product name of this products.
	 *
	 * @return the product name of this products
	 */
	@AutoEscape
	public String getProductName();

	/**
	 * Sets the product name of this products.
	 *
	 * @param productName the product name of this products
	 */
	public void setProductName(String productName);

	/**
	 * Returns the product description of this products.
	 *
	 * @return the product description of this products
	 */
	@AutoEscape
	public String getProductDescription();

	/**
	 * Sets the product description of this products.
	 *
	 * @param productDescription the product description of this products
	 */
	public void setProductDescription(String productDescription);

	/**
	 * Returns the url title of this products.
	 *
	 * @return the url title of this products
	 */
	@AutoEscape
	public String getUrlTitle();

	/**
	 * Sets the url title of this products.
	 *
	 * @param urlTitle the url title of this products
	 */
	public void setUrlTitle(String urlTitle);

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public Serializable getPrimaryKeyObj();

	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(Products products);

	public int hashCode();

	public CacheModel<Products> toCacheModel();

	public Products toEscapedModel();

	public String toString();

	public String toXmlString();
}