/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.assetsintegration.model;

import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Products}.
 * </p>
 *
 * @author    Jack A. Rider
 * @see       Products
 * @generated
 */
public class ProductsWrapper implements Products, ModelWrapper<Products> {
	public ProductsWrapper(Products products) {
		_products = products;
	}

	public Class<?> getModelClass() {
		return Products.class;
	}

	public String getModelClassName() {
		return Products.class.getName();
	}

	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("uuid", getUuid());
		attributes.put("productId", getProductId());
		attributes.put("companyId", getCompanyId());
		attributes.put("groupId", getGroupId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("productName", getProductName());
		attributes.put("productDescription", getProductDescription());
		attributes.put("urlTitle", getUrlTitle());

		return attributes;
	}

	public void setModelAttributes(Map<String, Object> attributes) {
		String uuid = (String)attributes.get("uuid");

		if (uuid != null) {
			setUuid(uuid);
		}

		Long productId = (Long)attributes.get("productId");

		if (productId != null) {
			setProductId(productId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String productName = (String)attributes.get("productName");

		if (productName != null) {
			setProductName(productName);
		}

		String productDescription = (String)attributes.get("productDescription");

		if (productDescription != null) {
			setProductDescription(productDescription);
		}

		String urlTitle = (String)attributes.get("urlTitle");

		if (urlTitle != null) {
			setUrlTitle(urlTitle);
		}
	}

	/**
	* Returns the primary key of this products.
	*
	* @return the primary key of this products
	*/
	public long getPrimaryKey() {
		return _products.getPrimaryKey();
	}

	/**
	* Sets the primary key of this products.
	*
	* @param primaryKey the primary key of this products
	*/
	public void setPrimaryKey(long primaryKey) {
		_products.setPrimaryKey(primaryKey);
	}

	/**
	* Returns the uuid of this products.
	*
	* @return the uuid of this products
	*/
	public java.lang.String getUuid() {
		return _products.getUuid();
	}

	/**
	* Sets the uuid of this products.
	*
	* @param uuid the uuid of this products
	*/
	public void setUuid(java.lang.String uuid) {
		_products.setUuid(uuid);
	}

	/**
	* Returns the product ID of this products.
	*
	* @return the product ID of this products
	*/
	public long getProductId() {
		return _products.getProductId();
	}

	/**
	* Sets the product ID of this products.
	*
	* @param productId the product ID of this products
	*/
	public void setProductId(long productId) {
		_products.setProductId(productId);
	}

	/**
	* Returns the company ID of this products.
	*
	* @return the company ID of this products
	*/
	public long getCompanyId() {
		return _products.getCompanyId();
	}

	/**
	* Sets the company ID of this products.
	*
	* @param companyId the company ID of this products
	*/
	public void setCompanyId(long companyId) {
		_products.setCompanyId(companyId);
	}

	/**
	* Returns the group ID of this products.
	*
	* @return the group ID of this products
	*/
	public long getGroupId() {
		return _products.getGroupId();
	}

	/**
	* Sets the group ID of this products.
	*
	* @param groupId the group ID of this products
	*/
	public void setGroupId(long groupId) {
		_products.setGroupId(groupId);
	}

	/**
	* Returns the user ID of this products.
	*
	* @return the user ID of this products
	*/
	public long getUserId() {
		return _products.getUserId();
	}

	/**
	* Sets the user ID of this products.
	*
	* @param userId the user ID of this products
	*/
	public void setUserId(long userId) {
		_products.setUserId(userId);
	}

	/**
	* Returns the user uuid of this products.
	*
	* @return the user uuid of this products
	* @throws SystemException if a system exception occurred
	*/
	public java.lang.String getUserUuid()
		throws com.liferay.portal.kernel.exception.SystemException {
		return _products.getUserUuid();
	}

	/**
	* Sets the user uuid of this products.
	*
	* @param userUuid the user uuid of this products
	*/
	public void setUserUuid(java.lang.String userUuid) {
		_products.setUserUuid(userUuid);
	}

	/**
	* Returns the user name of this products.
	*
	* @return the user name of this products
	*/
	public java.lang.String getUserName() {
		return _products.getUserName();
	}

	/**
	* Sets the user name of this products.
	*
	* @param userName the user name of this products
	*/
	public void setUserName(java.lang.String userName) {
		_products.setUserName(userName);
	}

	/**
	* Returns the create date of this products.
	*
	* @return the create date of this products
	*/
	public java.util.Date getCreateDate() {
		return _products.getCreateDate();
	}

	/**
	* Sets the create date of this products.
	*
	* @param createDate the create date of this products
	*/
	public void setCreateDate(java.util.Date createDate) {
		_products.setCreateDate(createDate);
	}

	/**
	* Returns the modified date of this products.
	*
	* @return the modified date of this products
	*/
	public java.util.Date getModifiedDate() {
		return _products.getModifiedDate();
	}

	/**
	* Sets the modified date of this products.
	*
	* @param modifiedDate the modified date of this products
	*/
	public void setModifiedDate(java.util.Date modifiedDate) {
		_products.setModifiedDate(modifiedDate);
	}

	/**
	* Returns the product name of this products.
	*
	* @return the product name of this products
	*/
	public java.lang.String getProductName() {
		return _products.getProductName();
	}

	/**
	* Sets the product name of this products.
	*
	* @param productName the product name of this products
	*/
	public void setProductName(java.lang.String productName) {
		_products.setProductName(productName);
	}

	/**
	* Returns the product description of this products.
	*
	* @return the product description of this products
	*/
	public java.lang.String getProductDescription() {
		return _products.getProductDescription();
	}

	/**
	* Sets the product description of this products.
	*
	* @param productDescription the product description of this products
	*/
	public void setProductDescription(java.lang.String productDescription) {
		_products.setProductDescription(productDescription);
	}

	/**
	* Returns the url title of this products.
	*
	* @return the url title of this products
	*/
	public java.lang.String getUrlTitle() {
		return _products.getUrlTitle();
	}

	/**
	* Sets the url title of this products.
	*
	* @param urlTitle the url title of this products
	*/
	public void setUrlTitle(java.lang.String urlTitle) {
		_products.setUrlTitle(urlTitle);
	}

	public boolean isNew() {
		return _products.isNew();
	}

	public void setNew(boolean n) {
		_products.setNew(n);
	}

	public boolean isCachedModel() {
		return _products.isCachedModel();
	}

	public void setCachedModel(boolean cachedModel) {
		_products.setCachedModel(cachedModel);
	}

	public boolean isEscapedModel() {
		return _products.isEscapedModel();
	}

	public java.io.Serializable getPrimaryKeyObj() {
		return _products.getPrimaryKeyObj();
	}

	public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
		_products.setPrimaryKeyObj(primaryKeyObj);
	}

	public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
		return _products.getExpandoBridge();
	}

	public void setExpandoBridgeAttributes(
		com.liferay.portal.service.ServiceContext serviceContext) {
		_products.setExpandoBridgeAttributes(serviceContext);
	}

	@Override
	public java.lang.Object clone() {
		return new ProductsWrapper((Products)_products.clone());
	}

	public int compareTo(
		org.xmlportletfactory.xmlpf.assetsintegration.model.Products products) {
		return _products.compareTo(products);
	}

	@Override
	public int hashCode() {
		return _products.hashCode();
	}

	public com.liferay.portal.model.CacheModel<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> toCacheModel() {
		return _products.toCacheModel();
	}

	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products toEscapedModel() {
		return new ProductsWrapper(_products.toEscapedModel());
	}

	@Override
	public java.lang.String toString() {
		return _products.toString();
	}

	public java.lang.String toXmlString() {
		return _products.toXmlString();
	}

	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		_products.persist();
	}

	/**
	 * @deprecated Renamed to {@link #getWrappedModel}
	 */
	public Products getWrappedProducts() {
		return _products;
	}

	public Products getWrappedModel() {
		return _products;
	}

	public void resetOriginalValues() {
		_products.resetOriginalValues();
	}

	private Products _products;
}