/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.assetsintegration.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import org.xmlportletfactory.xmlpf.assetsintegration.model.Products;

/**
 * The persistence interface for the products service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Jack A. Rider
 * @see ProductsPersistenceImpl
 * @see ProductsUtil
 * @generated
 */
public interface ProductsPersistence extends BasePersistence<Products> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link ProductsUtil} to access the products persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
	 */

	/**
	* Caches the products in the entity cache if it is enabled.
	*
	* @param products the products
	*/
	public void cacheResult(
		org.xmlportletfactory.xmlpf.assetsintegration.model.Products products);

	/**
	* Caches the productses in the entity cache if it is enabled.
	*
	* @param productses the productses
	*/
	public void cacheResult(
		java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> productses);

	/**
	* Creates a new products with the primary key. Does not add the products to the database.
	*
	* @param productId the primary key for the new products
	* @return the new products
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products create(
		long productId);

	/**
	* Removes the products with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param productId the primary key of the products
	* @return the products that was removed
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products remove(
		long productId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products updateImpl(
		org.xmlportletfactory.xmlpf.assetsintegration.model.Products products,
		boolean merge)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the products with the primary key or throws a {@link org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException} if it could not be found.
	*
	* @param productId the primary key of the products
	* @return the products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByPrimaryKey(
		long productId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the products with the primary key or returns <code>null</code> if it could not be found.
	*
	* @param productId the primary key of the products
	* @return the products, or <code>null</code> if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByPrimaryKey(
		long productId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns all the productses where uuid = &#63;.
	*
	* @param uuid the uuid
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUuid(
		java.lang.String uuid)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the productses where uuid = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param uuid the uuid
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUuid(
		java.lang.String uuid, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the productses where uuid = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param uuid the uuid
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUuid(
		java.lang.String uuid, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first products in the ordered set where uuid = &#63;.
	*
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUuid_First(
		java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the first products in the ordered set where uuid = &#63;.
	*
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUuid_First(
		java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last products in the ordered set where uuid = &#63;.
	*
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUuid_Last(
		java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the last products in the ordered set where uuid = &#63;.
	*
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUuid_Last(
		java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the productses before and after the current products in the ordered set where uuid = &#63;.
	*
	* @param productId the primary key of the current products
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByUuid_PrevAndNext(
		long productId, java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the products where uuid = &#63; and groupId = &#63; or throws a {@link org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException} if it could not be found.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @return the matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUUID_G(
		java.lang.String uuid, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the products where uuid = &#63; and groupId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUUID_G(
		java.lang.String uuid, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the products where uuid = &#63; and groupId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @param retrieveFromCache whether to use the finder cache
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUUID_G(
		java.lang.String uuid, long groupId, boolean retrieveFromCache)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the products where groupId = &#63; and urlTitle = &#63; or throws a {@link org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException} if it could not be found.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @return the matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByG_UT(
		long groupId, java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the products where groupId = &#63; and urlTitle = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByG_UT(
		long groupId, java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the products where groupId = &#63; and urlTitle = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @param retrieveFromCache whether to use the finder cache
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByG_UT(
		long groupId, java.lang.String urlTitle, boolean retrieveFromCache)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the products where urlTitle = &#63; or throws a {@link org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException} if it could not be found.
	*
	* @param urlTitle the url title
	* @return the matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByURLTitle(
		java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the products where urlTitle = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	*
	* @param urlTitle the url title
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByURLTitle(
		java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the products where urlTitle = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	*
	* @param urlTitle the url title
	* @param retrieveFromCache whether to use the finder cache
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByURLTitle(
		java.lang.String urlTitle, boolean retrieveFromCache)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns all the productses where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByGroupId(
		long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the productses where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByGroupId(
		long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the productses where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByGroupId(
		long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first products in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByGroupId_First(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the first products in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByGroupId_First(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last products in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByGroupId_Last(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the last products in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByGroupId_Last(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the productses before and after the current products in the ordered set where groupId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByGroupId_PrevAndNext(
		long productId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns all the productses that the user has permission to view where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByGroupId(
		long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the productses that the user has permission to view where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByGroupId(
		long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the productses that the user has permissions to view where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByGroupId(
		long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the productses before and after the current products in the ordered set of productses that the user has permission to view where groupId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] filterFindByGroupId_PrevAndNext(
		long productId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns all the productses where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserIdGroupId(
		long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the productses where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserIdGroupId(
		long userId, long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the productses where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserIdGroupId(
		long userId, long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUserIdGroupId_First(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the first products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUserIdGroupId_First(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUserIdGroupId_Last(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the last products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUserIdGroupId_Last(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the productses before and after the current products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByUserIdGroupId_PrevAndNext(
		long productId, long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns all the productses that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByUserIdGroupId(
		long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the productses that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByUserIdGroupId(
		long userId, long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the productses that the user has permissions to view where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByUserIdGroupId(
		long userId, long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the productses before and after the current products in the ordered set of productses that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] filterFindByUserIdGroupId_PrevAndNext(
		long productId, long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns all the productses where userId = &#63;.
	*
	* @param userId the user ID
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserId(
		long userId) throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the productses where userId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserId(
		long userId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the productses where userId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserId(
		long userId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first products in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUserId_First(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the first products in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUserId_First(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last products in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUserId_Last(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the last products in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUserId_Last(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the productses before and after the current products in the ordered set where userId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByUserId_PrevAndNext(
		long productId, long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns all the productses where companyId = &#63;.
	*
	* @param companyId the company ID
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByCompanyId(
		long companyId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the productses where companyId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param companyId the company ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByCompanyId(
		long companyId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the productses where companyId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param companyId the company ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByCompanyId(
		long companyId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the first products in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByCompanyId_First(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the first products in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByCompanyId_First(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the last products in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByCompanyId_Last(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns the last products in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByCompanyId_Last(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the productses before and after the current products in the ordered set where companyId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByCompanyId_PrevAndNext(
		long productId, long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Returns all the productses.
	*
	* @return the productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns a range of all the productses.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findAll(
		int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns an ordered range of all the productses.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of productses
	* @throws SystemException if a system exception occurred
	*/
	public java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findAll(
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the productses where uuid = &#63; from the database.
	*
	* @param uuid the uuid
	* @throws SystemException if a system exception occurred
	*/
	public void removeByUuid(java.lang.String uuid)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes the products where uuid = &#63; and groupId = &#63; from the database.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @return the products that was removed
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products removeByUUID_G(
		java.lang.String uuid, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Removes the products where groupId = &#63; and urlTitle = &#63; from the database.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @return the products that was removed
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products removeByG_UT(
		long groupId, java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Removes the products where urlTitle = &#63; from the database.
	*
	* @param urlTitle the url title
	* @return the products that was removed
	* @throws SystemException if a system exception occurred
	*/
	public org.xmlportletfactory.xmlpf.assetsintegration.model.Products removeByURLTitle(
		java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;

	/**
	* Removes all the productses where groupId = &#63; from the database.
	*
	* @param groupId the group ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByGroupId(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the productses where userId = &#63; and groupId = &#63; from the database.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByUserIdGroupId(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the productses where userId = &#63; from the database.
	*
	* @param userId the user ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByUserId(long userId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the productses where companyId = &#63; from the database.
	*
	* @param companyId the company ID
	* @throws SystemException if a system exception occurred
	*/
	public void removeByCompanyId(long companyId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Removes all the productses from the database.
	*
	* @throws SystemException if a system exception occurred
	*/
	public void removeAll()
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses where uuid = &#63;.
	*
	* @param uuid the uuid
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public int countByUuid(java.lang.String uuid)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses where uuid = &#63; and groupId = &#63;.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public int countByUUID_G(java.lang.String uuid, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses where groupId = &#63; and urlTitle = &#63;.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public int countByG_UT(long groupId, java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses where urlTitle = &#63;.
	*
	* @param urlTitle the url title
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public int countByURLTitle(java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public int countByGroupId(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses that the user has permission to view where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the number of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public int filterCountByGroupId(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public int countByUserIdGroupId(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the number of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public int filterCountByUserIdGroupId(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses where userId = &#63;.
	*
	* @param userId the user ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public int countByUserId(long userId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses where companyId = &#63;.
	*
	* @param companyId the company ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public int countByCompanyId(long companyId)
		throws com.liferay.portal.kernel.exception.SystemException;

	/**
	* Returns the number of productses.
	*
	* @return the number of productses
	* @throws SystemException if a system exception occurred
	*/
	public int countAll()
		throws com.liferay.portal.kernel.exception.SystemException;
}