/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.assetsintegration.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import org.xmlportletfactory.xmlpf.assetsintegration.model.Products;

import java.util.List;

/**
 * The persistence utility for the products service. This utility wraps {@link ProductsPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Jack A. Rider
 * @see ProductsPersistence
 * @see ProductsPersistenceImpl
 * @generated
 */
public class ProductsUtil {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
	 */

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
	 */
	public static void clearCache() {
		getPersistence().clearCache();
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
	 */
	public static void clearCache(Products products) {
		getPersistence().clearCache(products);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
	 */
	public long countWithDynamicQuery(DynamicQuery dynamicQuery)
		throws SystemException {
		return getPersistence().countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
	 */
	public static List<Products> findWithDynamicQuery(DynamicQuery dynamicQuery)
		throws SystemException {
		return getPersistence().findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
	 */
	public static List<Products> findWithDynamicQuery(
		DynamicQuery dynamicQuery, int start, int end)
		throws SystemException {
		return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
	 */
	public static List<Products> findWithDynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator orderByComparator) throws SystemException {
		return getPersistence()
				   .findWithDynamicQuery(dynamicQuery, start, end,
			orderByComparator);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, boolean)
	 */
	public static Products update(Products products, boolean merge)
		throws SystemException {
		return getPersistence().update(products, merge);
	}

	/**
	 * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, boolean, ServiceContext)
	 */
	public static Products update(Products products, boolean merge,
		ServiceContext serviceContext) throws SystemException {
		return getPersistence().update(products, merge, serviceContext);
	}

	/**
	* Caches the products in the entity cache if it is enabled.
	*
	* @param products the products
	*/
	public static void cacheResult(
		org.xmlportletfactory.xmlpf.assetsintegration.model.Products products) {
		getPersistence().cacheResult(products);
	}

	/**
	* Caches the productses in the entity cache if it is enabled.
	*
	* @param productses the productses
	*/
	public static void cacheResult(
		java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> productses) {
		getPersistence().cacheResult(productses);
	}

	/**
	* Creates a new products with the primary key. Does not add the products to the database.
	*
	* @param productId the primary key for the new products
	* @return the new products
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products create(
		long productId) {
		return getPersistence().create(productId);
	}

	/**
	* Removes the products with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param productId the primary key of the products
	* @return the products that was removed
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products remove(
		long productId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().remove(productId);
	}

	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products updateImpl(
		org.xmlportletfactory.xmlpf.assetsintegration.model.Products products,
		boolean merge)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().updateImpl(products, merge);
	}

	/**
	* Returns the products with the primary key or throws a {@link org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException} if it could not be found.
	*
	* @param productId the primary key of the products
	* @return the products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByPrimaryKey(
		long productId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByPrimaryKey(productId);
	}

	/**
	* Returns the products with the primary key or returns <code>null</code> if it could not be found.
	*
	* @param productId the primary key of the products
	* @return the products, or <code>null</code> if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByPrimaryKey(
		long productId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByPrimaryKey(productId);
	}

	/**
	* Returns all the productses where uuid = &#63;.
	*
	* @param uuid the uuid
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUuid(
		java.lang.String uuid)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByUuid(uuid);
	}

	/**
	* Returns a range of all the productses where uuid = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param uuid the uuid
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUuid(
		java.lang.String uuid, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByUuid(uuid, start, end);
	}

	/**
	* Returns an ordered range of all the productses where uuid = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param uuid the uuid
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUuid(
		java.lang.String uuid, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByUuid(uuid, start, end, orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where uuid = &#63;.
	*
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUuid_First(
		java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByUuid_First(uuid, orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where uuid = &#63;.
	*
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUuid_First(
		java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByUuid_First(uuid, orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where uuid = &#63;.
	*
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUuid_Last(
		java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByUuid_Last(uuid, orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where uuid = &#63;.
	*
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUuid_Last(
		java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByUuid_Last(uuid, orderByComparator);
	}

	/**
	* Returns the productses before and after the current products in the ordered set where uuid = &#63;.
	*
	* @param productId the primary key of the current products
	* @param uuid the uuid
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByUuid_PrevAndNext(
		long productId, java.lang.String uuid,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .findByUuid_PrevAndNext(productId, uuid, orderByComparator);
	}

	/**
	* Returns the products where uuid = &#63; and groupId = &#63; or throws a {@link org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException} if it could not be found.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @return the matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUUID_G(
		java.lang.String uuid, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByUUID_G(uuid, groupId);
	}

	/**
	* Returns the products where uuid = &#63; and groupId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUUID_G(
		java.lang.String uuid, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByUUID_G(uuid, groupId);
	}

	/**
	* Returns the products where uuid = &#63; and groupId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @param retrieveFromCache whether to use the finder cache
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUUID_G(
		java.lang.String uuid, long groupId, boolean retrieveFromCache)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByUUID_G(uuid, groupId, retrieveFromCache);
	}

	/**
	* Returns the products where groupId = &#63; and urlTitle = &#63; or throws a {@link org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException} if it could not be found.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @return the matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByG_UT(
		long groupId, java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByG_UT(groupId, urlTitle);
	}

	/**
	* Returns the products where groupId = &#63; and urlTitle = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByG_UT(
		long groupId, java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByG_UT(groupId, urlTitle);
	}

	/**
	* Returns the products where groupId = &#63; and urlTitle = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @param retrieveFromCache whether to use the finder cache
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByG_UT(
		long groupId, java.lang.String urlTitle, boolean retrieveFromCache)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByG_UT(groupId, urlTitle, retrieveFromCache);
	}

	/**
	* Returns the products where urlTitle = &#63; or throws a {@link org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException} if it could not be found.
	*
	* @param urlTitle the url title
	* @return the matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByURLTitle(
		java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByURLTitle(urlTitle);
	}

	/**
	* Returns the products where urlTitle = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	*
	* @param urlTitle the url title
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByURLTitle(
		java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByURLTitle(urlTitle);
	}

	/**
	* Returns the products where urlTitle = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	*
	* @param urlTitle the url title
	* @param retrieveFromCache whether to use the finder cache
	* @return the matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByURLTitle(
		java.lang.String urlTitle, boolean retrieveFromCache)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByURLTitle(urlTitle, retrieveFromCache);
	}

	/**
	* Returns all the productses where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByGroupId(
		long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByGroupId(groupId);
	}

	/**
	* Returns a range of all the productses where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByGroupId(
		long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByGroupId(groupId, start, end);
	}

	/**
	* Returns an ordered range of all the productses where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByGroupId(
		long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .findByGroupId(groupId, start, end, orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByGroupId_First(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByGroupId_First(groupId, orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByGroupId_First(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByGroupId_First(groupId, orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByGroupId_Last(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByGroupId_Last(groupId, orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where groupId = &#63;.
	*
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByGroupId_Last(
		long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByGroupId_Last(groupId, orderByComparator);
	}

	/**
	* Returns the productses before and after the current products in the ordered set where groupId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByGroupId_PrevAndNext(
		long productId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .findByGroupId_PrevAndNext(productId, groupId,
			orderByComparator);
	}

	/**
	* Returns all the productses that the user has permission to view where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByGroupId(
		long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().filterFindByGroupId(groupId);
	}

	/**
	* Returns a range of all the productses that the user has permission to view where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByGroupId(
		long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().filterFindByGroupId(groupId, start, end);
	}

	/**
	* Returns an ordered range of all the productses that the user has permissions to view where groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByGroupId(
		long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .filterFindByGroupId(groupId, start, end, orderByComparator);
	}

	/**
	* Returns the productses before and after the current products in the ordered set of productses that the user has permission to view where groupId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] filterFindByGroupId_PrevAndNext(
		long productId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .filterFindByGroupId_PrevAndNext(productId, groupId,
			orderByComparator);
	}

	/**
	* Returns all the productses where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserIdGroupId(
		long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByUserIdGroupId(userId, groupId);
	}

	/**
	* Returns a range of all the productses where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserIdGroupId(
		long userId, long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByUserIdGroupId(userId, groupId, start, end);
	}

	/**
	* Returns an ordered range of all the productses where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserIdGroupId(
		long userId, long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .findByUserIdGroupId(userId, groupId, start, end,
			orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUserIdGroupId_First(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .findByUserIdGroupId_First(userId, groupId, orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUserIdGroupId_First(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .fetchByUserIdGroupId_First(userId, groupId,
			orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUserIdGroupId_Last(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .findByUserIdGroupId_Last(userId, groupId, orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUserIdGroupId_Last(
		long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .fetchByUserIdGroupId_Last(userId, groupId, orderByComparator);
	}

	/**
	* Returns the productses before and after the current products in the ordered set where userId = &#63; and groupId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByUserIdGroupId_PrevAndNext(
		long productId, long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .findByUserIdGroupId_PrevAndNext(productId, userId, groupId,
			orderByComparator);
	}

	/**
	* Returns all the productses that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByUserIdGroupId(
		long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().filterFindByUserIdGroupId(userId, groupId);
	}

	/**
	* Returns a range of all the productses that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByUserIdGroupId(
		long userId, long groupId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .filterFindByUserIdGroupId(userId, groupId, start, end);
	}

	/**
	* Returns an ordered range of all the productses that the user has permissions to view where userId = &#63; and groupId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> filterFindByUserIdGroupId(
		long userId, long groupId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .filterFindByUserIdGroupId(userId, groupId, start, end,
			orderByComparator);
	}

	/**
	* Returns the productses before and after the current products in the ordered set of productses that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param userId the user ID
	* @param groupId the group ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] filterFindByUserIdGroupId_PrevAndNext(
		long productId, long userId, long groupId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .filterFindByUserIdGroupId_PrevAndNext(productId, userId,
			groupId, orderByComparator);
	}

	/**
	* Returns all the productses where userId = &#63;.
	*
	* @param userId the user ID
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserId(
		long userId) throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByUserId(userId);
	}

	/**
	* Returns a range of all the productses where userId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserId(
		long userId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByUserId(userId, start, end);
	}

	/**
	* Returns an ordered range of all the productses where userId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param userId the user ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByUserId(
		long userId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .findByUserId(userId, start, end, orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUserId_First(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByUserId_First(userId, orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUserId_First(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByUserId_First(userId, orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByUserId_Last(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().findByUserId_Last(userId, orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where userId = &#63;.
	*
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByUserId_Last(
		long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().fetchByUserId_Last(userId, orderByComparator);
	}

	/**
	* Returns the productses before and after the current products in the ordered set where userId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param userId the user ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByUserId_PrevAndNext(
		long productId, long userId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .findByUserId_PrevAndNext(productId, userId,
			orderByComparator);
	}

	/**
	* Returns all the productses where companyId = &#63;.
	*
	* @param companyId the company ID
	* @return the matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByCompanyId(
		long companyId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByCompanyId(companyId);
	}

	/**
	* Returns a range of all the productses where companyId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param companyId the company ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByCompanyId(
		long companyId, int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findByCompanyId(companyId, start, end);
	}

	/**
	* Returns an ordered range of all the productses where companyId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param companyId the company ID
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findByCompanyId(
		long companyId, int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .findByCompanyId(companyId, start, end, orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByCompanyId_First(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .findByCompanyId_First(companyId, orderByComparator);
	}

	/**
	* Returns the first products in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByCompanyId_First(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .fetchByCompanyId_First(companyId, orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products findByCompanyId_Last(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .findByCompanyId_Last(companyId, orderByComparator);
	}

	/**
	* Returns the last products in the ordered set where companyId = &#63;.
	*
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching products, or <code>null</code> if a matching products could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products fetchByCompanyId_Last(
		long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence()
				   .fetchByCompanyId_Last(companyId, orderByComparator);
	}

	/**
	* Returns the productses before and after the current products in the ordered set where companyId = &#63;.
	*
	* @param productId the primary key of the current products
	* @param companyId the company ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next products
	* @throws org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException if a products with the primary key could not be found
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products[] findByCompanyId_PrevAndNext(
		long productId, long companyId,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence()
				   .findByCompanyId_PrevAndNext(productId, companyId,
			orderByComparator);
	}

	/**
	* Returns all the productses.
	*
	* @return the productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findAll()
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findAll();
	}

	/**
	* Returns a range of all the productses.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @return the range of productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findAll(
		int start, int end)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findAll(start, end);
	}

	/**
	* Returns an ordered range of all the productses.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set.
	* </p>
	*
	* @param start the lower bound of the range of productses
	* @param end the upper bound of the range of productses (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of productses
	* @throws SystemException if a system exception occurred
	*/
	public static java.util.List<org.xmlportletfactory.xmlpf.assetsintegration.model.Products> findAll(
		int start, int end,
		com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().findAll(start, end, orderByComparator);
	}

	/**
	* Removes all the productses where uuid = &#63; from the database.
	*
	* @param uuid the uuid
	* @throws SystemException if a system exception occurred
	*/
	public static void removeByUuid(java.lang.String uuid)
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeByUuid(uuid);
	}

	/**
	* Removes the products where uuid = &#63; and groupId = &#63; from the database.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @return the products that was removed
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products removeByUUID_G(
		java.lang.String uuid, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().removeByUUID_G(uuid, groupId);
	}

	/**
	* Removes the products where groupId = &#63; and urlTitle = &#63; from the database.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @return the products that was removed
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products removeByG_UT(
		long groupId, java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().removeByG_UT(groupId, urlTitle);
	}

	/**
	* Removes the products where urlTitle = &#63; from the database.
	*
	* @param urlTitle the url title
	* @return the products that was removed
	* @throws SystemException if a system exception occurred
	*/
	public static org.xmlportletfactory.xmlpf.assetsintegration.model.Products removeByURLTitle(
		java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException,
			org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException {
		return getPersistence().removeByURLTitle(urlTitle);
	}

	/**
	* Removes all the productses where groupId = &#63; from the database.
	*
	* @param groupId the group ID
	* @throws SystemException if a system exception occurred
	*/
	public static void removeByGroupId(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeByGroupId(groupId);
	}

	/**
	* Removes all the productses where userId = &#63; and groupId = &#63; from the database.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @throws SystemException if a system exception occurred
	*/
	public static void removeByUserIdGroupId(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeByUserIdGroupId(userId, groupId);
	}

	/**
	* Removes all the productses where userId = &#63; from the database.
	*
	* @param userId the user ID
	* @throws SystemException if a system exception occurred
	*/
	public static void removeByUserId(long userId)
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeByUserId(userId);
	}

	/**
	* Removes all the productses where companyId = &#63; from the database.
	*
	* @param companyId the company ID
	* @throws SystemException if a system exception occurred
	*/
	public static void removeByCompanyId(long companyId)
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeByCompanyId(companyId);
	}

	/**
	* Removes all the productses from the database.
	*
	* @throws SystemException if a system exception occurred
	*/
	public static void removeAll()
		throws com.liferay.portal.kernel.exception.SystemException {
		getPersistence().removeAll();
	}

	/**
	* Returns the number of productses where uuid = &#63;.
	*
	* @param uuid the uuid
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static int countByUuid(java.lang.String uuid)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByUuid(uuid);
	}

	/**
	* Returns the number of productses where uuid = &#63; and groupId = &#63;.
	*
	* @param uuid the uuid
	* @param groupId the group ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static int countByUUID_G(java.lang.String uuid, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByUUID_G(uuid, groupId);
	}

	/**
	* Returns the number of productses where groupId = &#63; and urlTitle = &#63;.
	*
	* @param groupId the group ID
	* @param urlTitle the url title
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static int countByG_UT(long groupId, java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByG_UT(groupId, urlTitle);
	}

	/**
	* Returns the number of productses where urlTitle = &#63;.
	*
	* @param urlTitle the url title
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static int countByURLTitle(java.lang.String urlTitle)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByURLTitle(urlTitle);
	}

	/**
	* Returns the number of productses where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static int countByGroupId(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByGroupId(groupId);
	}

	/**
	* Returns the number of productses that the user has permission to view where groupId = &#63;.
	*
	* @param groupId the group ID
	* @return the number of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public static int filterCountByGroupId(long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().filterCountByGroupId(groupId);
	}

	/**
	* Returns the number of productses where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static int countByUserIdGroupId(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByUserIdGroupId(userId, groupId);
	}

	/**
	* Returns the number of productses that the user has permission to view where userId = &#63; and groupId = &#63;.
	*
	* @param userId the user ID
	* @param groupId the group ID
	* @return the number of matching productses that the user has permission to view
	* @throws SystemException if a system exception occurred
	*/
	public static int filterCountByUserIdGroupId(long userId, long groupId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().filterCountByUserIdGroupId(userId, groupId);
	}

	/**
	* Returns the number of productses where userId = &#63;.
	*
	* @param userId the user ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static int countByUserId(long userId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByUserId(userId);
	}

	/**
	* Returns the number of productses where companyId = &#63;.
	*
	* @param companyId the company ID
	* @return the number of matching productses
	* @throws SystemException if a system exception occurred
	*/
	public static int countByCompanyId(long companyId)
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countByCompanyId(companyId);
	}

	/**
	* Returns the number of productses.
	*
	* @return the number of productses
	* @throws SystemException if a system exception occurred
	*/
	public static int countAll()
		throws com.liferay.portal.kernel.exception.SystemException {
		return getPersistence().countAll();
	}

	public static ProductsPersistence getPersistence() {
		if (_persistence == null) {
			_persistence = (ProductsPersistence)PortletBeanLocatorUtil.locate(org.xmlportletfactory.xmlpf.assetsintegration.service.ClpSerializer.getServletContextName(),
					ProductsPersistence.class.getName());

			ReferenceRegistry.registerReference(ProductsUtil.class,
				"_persistence");
		}

		return _persistence;
	}

	/**
	 * @deprecated
	 */
	public void setPersistence(ProductsPersistence persistence) {
	}

	private static ProductsPersistence _persistence;
}