/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
 
 
package org.xmlportletfactory.xmlpf.assetsintegration;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletURL;
import javax.portlet.ProcessAction;
import javax.portlet.ProcessEvent;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletConfig;
import javax.xml.namespace.QName;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.poi.ss.usermodel.Workbook;
import com.liferay.portal.kernel.servlet.HttpHeaders;

import com.liferay.portal.kernel.dao.search.SearchContainer;

import org.xmlportletfactory.xmlpf.assetsintegration.model.Products;
import org.xmlportletfactory.xmlpf.assetsintegration.model.impl.ProductsImpl;
import org.xmlportletfactory.xmlpf.assetsintegration.service.ProductsLocalServiceUtil;
import org.xmlportletfactory.xmlpf.assetsintegration.service.permission.ProductsPermission;
import org.xmlportletfactory.xmlpf.assetsintegration.service.permission.ProductsEntryPermission;


import org.xmlportletfactory.xmlpf.assetsintegration.util.ProductsUtil;

import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.util.JavaConstants;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ActionKeys;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;

/**
 * Portlet implementation class Products
 */
public class ProductsPortlet extends MVCPortlet {



	public void init() throws PortletException {

		// Edit Mode Pages
		editJSP = getInitParameter("edit-jsp");

		// Help Mode Pages
		helpJSP = getInitParameter("help-jsp");

		// View Mode Pages
		viewJSP = getInitParameter("view-jsp");

		// View Mode Edit Products
		editproductsJSP = getInitParameter("edit-products-jsp");

		// View Mode Entry Products
		viewproductsJSP = getInitParameter("view-products-jsp");
	}

	protected void include(String path, RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		PortletRequestDispatcher portletRequestDispatcher = getPortletContext()
				.getRequestDispatcher(path);

		if (portletRequestDispatcher == null) {
			// do nothing
			// _log.error(path + " is not a valid include");
		} else {
			portletRequestDispatcher.include(renderRequest, renderResponse);
		}
	}

	public void doView(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		String jsp = (String) renderRequest.getParameter("view");
		if (jsp == null || jsp.equals("")) {
			showViewDefault(renderRequest, renderResponse);
		} else if (jsp.equalsIgnoreCase("editProducts")) {
			try {
				showViewEditProducts(renderRequest, renderResponse);
			} catch (Exception ex) {
				_log.debug(ex);
				try {
					showViewDefault(renderRequest, renderResponse);
				} catch (Exception ex1) {
					_log.debug(ex1);
				}
			}
		}
	}

	public void doEdit(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		showEditDefault(renderRequest, renderResponse);
	}

	public void doHelp(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		include(helpJSP, renderRequest, renderResponse);
	}

	@SuppressWarnings("unchecked")
	public void showViewDefault(RenderRequest renderRequest,
			RenderResponse renderResponse) throws IOException, PortletException {

		ThemeDisplay themeDisplay = (ThemeDisplay) renderRequest
				.getAttribute(WebKeys.THEME_DISPLAY);

		long groupId = themeDisplay.getScopeGroupId();

		PermissionChecker permissionChecker = themeDisplay
				.getPermissionChecker();

		boolean hasAddPermission = ProductsPermission.contains(permissionChecker, groupId, "ADD_PRODUCTS");

		boolean hasModelPermissions = ProductsPermission.contains(permissionChecker, groupId, ActionKeys.PERMISSIONS);

		List<Products> tempResults = Collections.EMPTY_LIST;

		PortletPreferences prefs = renderRequest.getPreferences();

		String productsFilter = ParamUtil.getString(renderRequest, "productsFilter");

		String rowsPerPage = prefs.getValue("rows-per-page","5");
		String viewType = prefs.getValue("view-type", "0");

		Integer cur = 1;
		int containerStart = 0;
		int containerEnd = 0;
		String orderByType = renderRequest.getParameter("orderByType");
		String orderByCol = renderRequest.getParameter("orderByCol");
		try{
			cur = ParamUtil.getInteger(renderRequest, "cur");

		}catch (Exception e){
			cur = 1;
		}

		if (cur < 1){
			cur = 1;
		}

		if (Validator.isNotNull(productsFilter) || !productsFilter.equalsIgnoreCase("")) {
			rowsPerPage = "100";
			cur = 1;
		}

		containerStart = (cur - 1) * Integer.parseInt(rowsPerPage);
		containerEnd = containerStart + Integer.parseInt(rowsPerPage);

		int total = 0;
		try {
			PortalPreferences portalPrefs = PortletPreferencesFactoryUtil.getPortalPreferences(renderRequest);

			if (Validator.isNull(orderByCol) && Validator.isNull(orderByType)) {
				orderByCol = portalPrefs.getValue("Products_order", "Products-order-by-col", "productId");
				orderByType = portalPrefs.getValue("Products_order", "Products-order-by-type", "asc");
			}
			OrderByComparator comparator = ProductsComparator.getProductsOrderByComparator(orderByCol,orderByType);



			if (productsFilter.equalsIgnoreCase("")) {
				
				if (viewType.equals("0")){
					tempResults = ProductsLocalServiceUtil.findAllInGroup(groupId, containerStart, containerEnd, comparator);
					total = ProductsLocalServiceUtil.countAllInGroup(groupId);								
				}else if (viewType.equals("1")){
					tempResults = ProductsLocalServiceUtil.findAllInUser(themeDisplay.getUserId(), containerStart, containerEnd, comparator);
					total = ProductsLocalServiceUtil.countAllInUser(themeDisplay.getUserId());
				}else{
					tempResults = ProductsLocalServiceUtil.findAllInUserAndGroup(themeDisplay.getUserId(), groupId, containerStart, containerEnd, comparator);
					total = ProductsLocalServiceUtil.countAllInUserAndGroup(themeDisplay.getUserId(), groupId);
				}

			} else {

				Indexer indexer = IndexerRegistryUtil.getIndexer(Products.class);

				SearchContext searchContext = SearchContextFactory.getInstance(PortalUtil.getHttpServletRequest(renderRequest));

				searchContext.setEnd(containerEnd);
				searchContext.setKeywords(productsFilter);
				searchContext.setStart(containerStart);

				Hits results = indexer.search(searchContext);

				total = results.getLength();

				if (total > 0) {
					tempResults = new ArrayList<Products>(total);
				}
				for (int i = 0; i < results.getDocs().length; i++) {
					Document doc = results.doc(i);

					Products resReg = null;

					// Entry
					long entryId = GetterUtil.getLong(doc.get(Field.ENTRY_CLASS_PK));

					try {
						resReg = ProductsLocalServiceUtil.getProducts(entryId);

						resReg = resReg.toEscapedModel();

						tempResults.add(resReg);
					}
					catch (Exception e) {
						if (_log.isWarnEnabled()) {
							_log.warn("Products search index is stale and contains entry " + entryId);
						}

						continue;
					}
				}
			}

		} catch (Exception e) {
			_log.debug(e);
		}
		renderRequest.setAttribute("highlightRowWithKey", renderRequest.getParameter("highlightRowWithKey"));
		renderRequest.setAttribute("containerStart", containerStart);
		renderRequest.setAttribute("containerEnd", containerEnd);
		renderRequest.setAttribute("cur", cur);
		renderRequest.setAttribute("tempResults", tempResults);
		renderRequest.setAttribute("totalCount", total);
		renderRequest.setAttribute("rowsPerPage", rowsPerPage);
		renderRequest.setAttribute("hasAddPermission", hasAddPermission);
		renderRequest.setAttribute("hasModelPermissions", hasModelPermissions);
		renderRequest.setAttribute("orderByType", orderByType);
		renderRequest.setAttribute("orderByCol", orderByCol);

		PortletURL addProductsURL = renderResponse.createActionURL();
		addProductsURL.setParameter("javax.portlet.action", "newProducts");
		renderRequest.setAttribute("addProductsURL", addProductsURL.toString());

		PortletURL productsFilterURL = renderResponse.createRenderURL();
		productsFilterURL.setParameter("javax.portlet.action", "doView");
		renderRequest.setAttribute("productsFilterURL", productsFilterURL.toString());

		include(viewJSP, renderRequest, renderResponse);
	}

	public void showViewEditProducts(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
		
		ThemeDisplay themeDisplay = (ThemeDisplay) renderRequest.getAttribute(WebKeys.THEME_DISPLAY);
		PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

		PortletURL editProductsURL = renderResponse.createActionURL();
		String editType = (String) renderRequest.getParameter("editType");
		boolean fromAsset = ProductsUtil.isFromAsset(renderRequest);

		Products products = null;
		boolean viewEntryMode=false;
		if (editType.equalsIgnoreCase("edit")) {			

			editProductsURL.setParameter("javax.portlet.action", "updateProducts");

			long $fname = Long.parseLong(renderRequest.getParameter("productId"));
			products = ProductsLocalServiceUtil.getProducts($fname);

			if (!ProductsEntryPermission.contains(
				permissionChecker, products, ActionKeys.UPDATE)){							
				SessionErrors.add(renderRequest, "permission-error");
				return;
	     		}

			renderRequest.setAttribute("fromAsset", fromAsset);
            	     	renderRequest.setAttribute("products", products);
		} else if (editType.equalsIgnoreCase("view")) {

			viewEntryMode= true;

			long $fname = Long.parseLong(renderRequest.getParameter("productId"));
			products = ProductsLocalServiceUtil.getProducts($fname);

			renderRequest.setAttribute("fromAsset", fromAsset);

			if (!ProductsEntryPermission.contains(
				permissionChecker, products, ActionKeys.VIEW)){							
				SessionErrors.add(renderRequest, "permission-error");
				return;
	     		}
			
			renderRequest.setAttribute("products", products);
		} else {

			if (!ProductsPermission.contains(
					permissionChecker, themeDisplay.getScopeGroupId(), "ADD_PRODUCTS")){	
				SessionErrors.add(renderRequest, "permission-error");
				return;
	    		}

			editProductsURL.setParameter("javax.portlet.action", "addProducts");
			Products errorProducts = (Products) renderRequest.getAttribute("errorProducts");
			renderRequest.setAttribute("fromAsset", fromAsset);
			if (errorProducts != null) {
				if (editType.equalsIgnoreCase("update")) {
					editProductsURL.setParameter("javax.portlet.action", "updateProducts");
                		}
				renderRequest.setAttribute("products", errorProducts);

			} else {				
				
				Products addProducts = null;

				renderRequest.setAttribute("fromAsset", fromAsset);

				if (Validator.isNull(renderRequest.getParameter("addErrors"))){
				
					addProducts = new ProductsImpl();
					addProducts.setProductId(0);
					addProducts.setProductName("");
					addProducts.setProductDescription("");
				}else{
					addProducts = ProductsFromRequest(renderRequest);
				}
				renderRequest.setAttribute("products", addProducts);
			}

		}		

		if (!viewEntryMode){
			renderRequest.setAttribute("editProductsURL", editProductsURL.toString());		
			include(editproductsJSP, renderRequest, renderResponse);
		}else{
			include(viewproductsJSP, renderRequest, renderResponse);
		}
	}

	private String dateToJsp(ActionRequest request, Date date) {
		PortletPreferences prefs = request.getPreferences();
		return dateToJsp(prefs, date);
	}
	private String dateToJsp(RenderRequest request, Date date) {
		PortletPreferences prefs = request.getPreferences();
		return dateToJsp(prefs, date);
	}
	private String dateToJsp(PortletPreferences prefs, Date date) {
		SimpleDateFormat format = new SimpleDateFormat(prefs.getValue("date-format", "yyyy/MM/dd"));
		String stringDate = format.format(date);
		return stringDate;
	}
	private String dateTimeToJsp(Date date) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
		String stringDate = format.format(date);
		return stringDate;
	}

	public void showEditDefault(RenderRequest renderRequest,
			RenderResponse renderResponse) throws PortletException, IOException {

		include(editJSP, renderRequest, renderResponse);
	}

	/* Portlet Actions */

	@ProcessAction(name = "newProducts")
	public void newProducts(ActionRequest request, ActionResponse response) throws Exception{
		ProductsUtil.addParametersForAdd(response);
		boolean fromAsset = ProductsUtil.isFromAsset(request);
		
	}

	@ProcessAction(name = "addProducts")
	public void addProducts(ActionRequest request, ActionResponse response) throws Exception {
            Products products = ProductsFromRequest(request);
	    ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
	    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

	    if (!ProductsPermission.contains(
					permissionChecker, themeDisplay.getScopeGroupId(), "ADD_PRODUCTS")){	
				ProductsUtil.addParametersForDefaultView(response);						
				SessionErrors.add(request, "permission-error");
				return;
	    }
            ArrayList<String> errors = ProductsValidator.validateProducts(products, request);

            if (errors.isEmpty()) {
		try {
			ServiceContext serviceContext = ServiceContextFactory.getInstance(Products.class.getName(), request);
			ProductsLocalServiceUtil.addProducts(products, serviceContext);

			ProductsUtil.addParametersForDefaultView(response);
                	SessionMessages.add(request, "products-added-successfully");
			boolean fromAsset = ProductsUtil.isFromAsset(request);

            	} catch (Exception cvex) {
            		SessionErrors.add(request, "please-enter-a-unique-code");
			PortalUtil.copyRequestParameters(request, response);			
			ProductsUtil.addParametersForAddWithErrors(response);		
            	}
            } else {
                for (String error : errors) {
                        SessionErrors.add(request, error);
                }
		PortalUtil.copyRequestParameters(request, response);			
		ProductsUtil.addParametersForAddWithErrors(response);	
            }
	}

	@ProcessAction(name = "eventProducts")
	public void eventProducts(ActionRequest request, ActionResponse response)
			throws Exception {
		long key = ParamUtil.getLong(request, "resourcePrimKey");
		int containerStart = ParamUtil.getInteger(request, "containerStart");
		int containerEnd = ParamUtil.getInteger(request, "containerEnd");
		int cur = ParamUtil.getInteger(request, "cur");
		String orderByType = ParamUtil.getString(request, "orderByType");
		String orderByCol = ParamUtil.getString(request, "orderByCol");
		String productsFilter = ParamUtil.getString(request, "ProductsFilter");
		if (Validator.isNotNull(key)) {
            		response.setRenderParameter("highlightRowWithKey", Long.toString(key));
            		response.setRenderParameter("containerStart", Integer.toString(containerStart));
            		response.setRenderParameter("containerEnd", Integer.toString(containerEnd));
			response.setRenderParameter("cur", Integer.toString(cur));
			response.setRenderParameter("orderByType", orderByType);
			response.setRenderParameter("orderByCol", orderByCol);
			response.setRenderParameter("ProductsFilter", productsFilter);
			boolean fromAsset = ProductsUtil.isFromAsset(request);
	
			if (!fromAsset) {
			}
		}
	}

	@ProcessAction(name = "editProducts")

	public void editProducts(ActionRequest request, ActionResponse response)
			throws Exception {
		long key = ParamUtil.getLong(request, "resourcePrimKey");
		if (Validator.isNotNull(key)) {
			ProductsUtil.addParametersForEdit(response, key);
			
			boolean fromAsset = ProductsUtil.isFromAsset(request);
			
			if (!fromAsset) {
			}
		}
	}

	@ProcessAction(name = "deleteProducts")
	public void deleteProducts(ActionRequest request, ActionResponse response)throws Exception {		

		long id = ParamUtil.getLong(request, "resourcePrimKey");

		if (Validator.isNotNull(id)) {
			ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
			PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

			if (!ProductsEntryPermission.contains(
					permissionChecker, id, ActionKeys.DELETE)){	
				ProductsUtil.addParametersForDefaultView(response);						
				SessionErrors.add(request, "permission-error");
				return;
			}

			Products products = ProductsLocalServiceUtil.getProducts(id);
			ProductsLocalServiceUtil.deleteProductsEntry(products);
			SessionMessages.add(request, "products-deleted-successfully");
            		response.setRenderParameter("productId", "0");
			boolean fromAsset = ProductsUtil.isFromAsset(request);
			
			if (!fromAsset) {
			}
		} else {
			SessionErrors.add(request, "products-error-deleting");
		}
	}

	@ProcessAction(name = "updateProducts")
	public void updateProducts(ActionRequest request, ActionResponse response) throws Exception {
            Products products = ProductsFromRequest(request);
	    ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
	    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();

	    if (!ProductsEntryPermission.contains(
				permissionChecker, products, ActionKeys.UPDATE)){	
				ProductsUtil.addParametersForDefaultView(response);						
				SessionErrors.add(request, "permission-error");
				return;
	     }

            ArrayList<String> errors = ProductsValidator.validateProducts(products, request);

	     boolean fromAsset = ProductsUtil.isFromAsset(request);

            if (errors.isEmpty()) {
            	try {
			ServiceContext serviceContext = ServiceContextFactory.getInstance(Products.class.getName(), request);
                	ProductsLocalServiceUtil.updateProducts(products, serviceContext);

			ProductsUtil.addParametersForDefaultView(response);
                	SessionMessages.add(request, "products-updated-successfully");

            	} catch (Exception cvex) {
            	    SessionErrors.add(request, "please-enter-a-unique-code");
		    		ProductsUtil.addParametersForEdit(response, null);
					request.setAttribute("products",products);
            	}
            } else {
                for (String error : errors) {
                        SessionErrors.add(request, error);
                }
				ProductsUtil.addParametersForEdit(response, Long.toString(products.getPrimaryKey()));
				request.setAttribute("products",products);
            }
	    if (!fromAsset) {
	    }
        }

	@ProcessAction(name = "setProductsPref")
	public void setProductsPref(ActionRequest request, ActionResponse response) throws Exception {

		String rowsPerPage = ParamUtil.getString(request, "rows-per-page");
		String viewType = ParamUtil.getString(request, "view-type");

		String dateFormat = ParamUtil.getString(request, "date-format");
		String datetimeFormat = ParamUtil.getString(request, "datetime-format");

		ArrayList<String> errors = new ArrayList();
		if (ProductsValidator.validateEditProducts(rowsPerPage, dateFormat, datetimeFormat, errors)) {
			response.setRenderParameter("rows-per-page", "");
			response.setRenderParameter("date-format", "");
			response.setRenderParameter("datetime-format", "");
			response.setRenderParameter("view-type", "");			

			PortletPreferences prefs = request.getPreferences();
			prefs.setValue("rows-per-page", rowsPerPage);
			prefs.setValue("view-type",viewType);
			prefs.setValue("date-format", dateFormat);
			prefs.setValue("datetime-format", datetimeFormat);
			prefs.store();

			SessionMessages.add(request, "prefs-success");
		}
	}

	private Products ProductsFromRequest(PortletRequest request) {
		ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
		ProductsImpl products = new ProductsImpl();
        	try {
            		products.setProductId(ParamUtil.getLong(request, "productId"));
        	} catch (Exception nfe) {
		    //Controled en Validator
        	}
		products.setProductName(ParamUtil.getString(request, "productName"));
		products.setProductDescription(ParamUtil.getString(request, "productDescription"));
		try {
		    	products.setPrimaryKey(ParamUtil.getLong(request,"resourcePrimKey"));
		} catch (NumberFormatException nfe) {
			//Controled en Validator
        	}

		products.setCompanyId(themeDisplay.getCompanyId());
		products.setGroupId(themeDisplay.getScopeGroupId());
		products.setUserId(themeDisplay.getUserId());
		return products;
	}



	public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
		resourceResponse.setContentType("text/javascript");
		String resourceId = resourceRequest.getResourceID();

		if (Validator.isNotNull(resourceId) && resourceId.length() != 0) {

			if(resourceId.equalsIgnoreCase("exportFullProductsResourceURL")) {

		    		ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute(WebKeys.THEME_DISPLAY);
		    		Locale locale = themeDisplay.getLocale();
		    		PortletConfig portletConfig = (PortletConfig)resourceRequest.getAttribute(JavaConstants.JAVAX_PORTLET_CONFIG);

		    		resourceResponse.setContentType("application/vnd.ms-excel");
		    		resourceResponse.setProperty("expires","-1d");
		    		resourceResponse.setProperty("Pragma","no-cache");
		    		resourceResponse.setProperty("Cache-control","no-cache");
				resourceResponse.addProperty(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\" Products\"");

				try {
					Workbook book = ProductsExporter.generateFullExcel(themeDisplay.getScopeGroupId(), portletConfig, locale);
					OutputStream out = resourceResponse.getPortletOutputStream();
					book.write(out);
					out.flush();
					out.close();
				} catch (SystemException e) {
					e.printStackTrace();
					throw new PortletException("Export Excel Error",e);
				}
			}

		}
	}

	protected String editproductsJSP;
	protected String editJSP;
	protected String helpJSP;
	protected String viewJSP;
	protected String viewproductsJSP;

	private static Log _log = LogFactoryUtil.getLog(ProductsPortlet.class);

}
