/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
 
 package org.xmlportletfactory.xmlpf.assetsintegration.asset;


import org.xmlportletfactory.xmlpf.assetsintegration.model.Products;
import org.xmlportletfactory.xmlpf.assetsintegration.service.permission.ProductsEntryPermission;
import org.xmlportletfactory.xmlpf.assetsintegration.util.ProductsUtil;


import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.permission.ActionKeys;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.BaseAssetRenderer;

import java.util.Locale;

import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;

/**
 * @author Jack A. Rider
 * @author Juan Gonzalez P.
 */
public class ProductsAssetRenderer extends BaseAssetRenderer {


	public ProductsAssetRenderer(Products entry) {
		_entry = entry;
	}

	public long getClassPK() {
		return _entry.getPrimaryKey();
	}	

	public long getGroupId() {
		return _entry.getGroupId();
	}

	public String getSummary(Locale locale) {
		return HtmlUtil.stripHtml(_entry.getProductName());
	}

	public String getTitle(Locale locale) {
		return _entry.getProductName();
	}

	@Override
	public PortletURL getURLEdit(
			LiferayPortletRequest liferayPortletRequest,
			LiferayPortletResponse liferayPortletResponse)
		throws Exception {

		//PortletURL portletURL = liferayPortletResponse.createActionURL();

		PortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(
				getControlPanelPlid(liferayPortletRequest),
				"Products_WAR_AssetsIntegrationportlet",
				PortletRequest.RENDER_PHASE);

		portletURL.setParameter("view", "editProducts");
		portletURL.setParameter("productId",  String.valueOf(_entry.getPrimaryKey()));	
                portletURL.setParameter("editType", "edit");	
		portletURL.setParameter("fromAsset","true");

		return portletURL;
	}

	@Override
	public String getUrlTitle() {
		return _entry.getUrlTitle();
	}
	
	public long getUserId() {
		return _entry.getUserId();
	}

	public String getUserName() {
		return _entry.getUserName();
	}

	public String getUuid() {
		return _entry.getUuid();
	}

	@Override
	public boolean hasEditPermission(PermissionChecker permissionChecker) {
		return ProductsEntryPermission.contains(
			permissionChecker, _entry, ActionKeys.UPDATE);
	}

	@Override
	public boolean hasViewPermission(PermissionChecker permissionChecker) {
		return ProductsEntryPermission.contains(
			permissionChecker, _entry, ActionKeys.VIEW);
	}

	@Override
	public String getURLViewInContext(
			LiferayPortletRequest liferayPortletRequest,
			LiferayPortletResponse liferayPortletResponse,
			String noSuchEntryRedirect) throws Exception {
		
		long plid = getCurrentPlid(liferayPortletRequest);

		try{
			plid =ProductsUtil.getPlid(getGroupId());
		} catch (Exception e){
		}

		PortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(plid, 
						"Products_WAR_AssetsIntegrationportlet", 
						PortletRequest.RENDER_PHASE);
		
		
		portletURL.setParameter("view", "editProducts");
		portletURL.setParameter("productId",  String.valueOf(_entry.getPrimaryKey()));	
                portletURL.setParameter("editType", "view");	
		portletURL.setParameter("fromAsset","true");
		portletURL.setParameter("noSuchEntryRedirect",noSuchEntryRedirect);
				
		return portletURL.toString();
	}

	@Override
	public boolean isPrintable() {
		return true;
	}

	public String render(
			RenderRequest renderRequest, RenderResponse renderResponse,
			String template)
		throws Exception {

		if (template.equals(TEMPLATE_FULL_CONTENT)) {

			renderRequest.setAttribute("products", _entry);
			
			return "/JSPs/products/asset_products_" + template + ".jsp";
		}
		else {
			return null;
		}
	}

	@Override
	protected String getIconPath(ThemeDisplay themeDisplay) {
		Portlet portlet = null; 
		String path="";	
		try{
			portlet = PortletLocalServiceUtil.getPortletById(themeDisplay.getCompanyId(),
				"Products_WAR_AssetsIntegrationportlet");
		} catch (Exception e){					
		}
		
			
		if (portlet!=null){
			path =portlet.getContextPath();
		}
		return path + "/icons/icon.png";
	}

	private long getCurrentPlid(LiferayPortletRequest request)
			throws PortalException, SystemException {
		ThemeDisplay themeDisplay = (ThemeDisplay) request
				.getAttribute(WebKeys.THEME_DISPLAY);
		return themeDisplay.getPlid();
	}

	private Products _entry;
}

