/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
 
 package org.xmlportletfactory.xmlpf.assetsintegration.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.permission.ActionKeys;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortletKeys;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import org.xmlportletfactory.xmlpf.assetsintegration.model.Products;
import org.xmlportletfactory.xmlpf.assetsintegration.service.permission.ProductsEntryPermission;
import org.xmlportletfactory.xmlpf.assetsintegration.service.permission.ProductsPermission;
import org.xmlportletfactory.xmlpf.assetsintegration.service.ProductsLocalServiceUtil;

import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

import javax.servlet.http.HttpServletRequest;


/**
 * @author Jack A. Rider
 * @author Juan Gonzalez P.
 */
public class ProductsAssetRendererFactory extends BaseAssetRendererFactory {


	public static final String CLASS_NAME = Products.class.getName();

	public static final String TYPE = "Products";

	private long getCurrentPlid(LiferayPortletRequest request)
			throws PortalException, SystemException {
		ThemeDisplay themeDisplay = (ThemeDisplay) request
				.getAttribute(WebKeys.THEME_DISPLAY);
		return themeDisplay.getPlid();
	}
	
	@Override
	public AssetRenderer getAssetRenderer(long groupId, String urlTitle)
		throws PortalException, SystemException {

		Products entry =
			ProductsLocalServiceUtil.getProductsByUrlTitle(
				groupId, urlTitle);

		return new ProductsAssetRenderer(entry);
	}
	
	public AssetRenderer getAssetRenderer(long classPK, int type)
		throws PortalException, SystemException {

		Products entry = ProductsLocalServiceUtil.getProducts(classPK);

		return new ProductsAssetRenderer(entry);
	}

	public String getClassName() {
		return CLASS_NAME;
	}

	public String getType() {
		return TYPE;
	}
	

	@Override
	public PortletURL getURLAdd(
			LiferayPortletRequest liferayPortletRequest,
			LiferayPortletResponse liferayPortletResponse)
		throws PortalException, SystemException {

		HttpServletRequest request =
			liferayPortletRequest.getHttpServletRequest();

		ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute(
			WebKeys.THEME_DISPLAY);

		if (!ProductsPermission.contains(
				themeDisplay.getPermissionChecker(),
				themeDisplay.getScopeGroupId(), 
				"ADD_PRODUCTS")) {

			return null;
		}
		
		PortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(
					getControlPanelPlid(themeDisplay),
					"Products_WAR_AssetsIntegrationportlet",
					PortletRequest.RENDER_PHASE);

		portletURL.setParameter("view", "editProducts");
		portletURL.setParameter("editType", "add");	
		portletURL.setParameter("fromAsset","true");			


		return portletURL;
	}

	@Override
	public boolean hasPermission(
			PermissionChecker permissionChecker, long classPK, String actionId)
		throws Exception {

		return ProductsEntryPermission.contains(
			permissionChecker, classPK, actionId);
	}

	@Override
	public boolean isLinkable() {
		return _LINKABLE;
	}

	@Override
	protected String getIconPath(ThemeDisplay themeDisplay) {
		Portlet portlet = null; 
		String path="";	
		try{
			portlet = PortletLocalServiceUtil.getPortletById(themeDisplay.getCompanyId(),
				"Products_WAR_AssetsIntegrationportlet");
		} catch (Exception e){					
		}
		
			
		if (portlet!=null){
			path =portlet.getContextPath();
		}		
		return path + "/icons/icon.png";
	}

	private static final boolean _LINKABLE = true;
}

