/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package org.xmlportletfactory.xmlpf.assetsintegration.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;

import org.xmlportletfactory.xmlpf.assetsintegration.model.Products;

import java.io.Serializable;

import java.util.Date;

/**
 * The cache model class for representing Products in entity cache.
 *
 * @author Jack A. Rider
 * @see Products
 * @generated
 */
public class ProductsCacheModel implements CacheModel<Products>, Serializable {
	@Override
	public String toString() {
		StringBundler sb = new StringBundler(23);

		sb.append("{uuid=");
		sb.append(uuid);
		sb.append(", productId=");
		sb.append(productId);
		sb.append(", companyId=");
		sb.append(companyId);
		sb.append(", groupId=");
		sb.append(groupId);
		sb.append(", userId=");
		sb.append(userId);
		sb.append(", userName=");
		sb.append(userName);
		sb.append(", createDate=");
		sb.append(createDate);
		sb.append(", modifiedDate=");
		sb.append(modifiedDate);
		sb.append(", productName=");
		sb.append(productName);
		sb.append(", productDescription=");
		sb.append(productDescription);
		sb.append(", urlTitle=");
		sb.append(urlTitle);
		sb.append("}");

		return sb.toString();
	}

	public Products toEntityModel() {
		ProductsImpl productsImpl = new ProductsImpl();

		if (uuid == null) {
			productsImpl.setUuid(StringPool.BLANK);
		}
		else {
			productsImpl.setUuid(uuid);
		}

		productsImpl.setProductId(productId);
		productsImpl.setCompanyId(companyId);
		productsImpl.setGroupId(groupId);
		productsImpl.setUserId(userId);

		if (userName == null) {
			productsImpl.setUserName(StringPool.BLANK);
		}
		else {
			productsImpl.setUserName(userName);
		}

		if (createDate == Long.MIN_VALUE) {
			productsImpl.setCreateDate(null);
		}
		else {
			productsImpl.setCreateDate(new Date(createDate));
		}

		if (modifiedDate == Long.MIN_VALUE) {
			productsImpl.setModifiedDate(null);
		}
		else {
			productsImpl.setModifiedDate(new Date(modifiedDate));
		}

		if (productName == null) {
			productsImpl.setProductName(StringPool.BLANK);
		}
		else {
			productsImpl.setProductName(productName);
		}

		if (productDescription == null) {
			productsImpl.setProductDescription(StringPool.BLANK);
		}
		else {
			productsImpl.setProductDescription(productDescription);
		}

		if (urlTitle == null) {
			productsImpl.setUrlTitle(StringPool.BLANK);
		}
		else {
			productsImpl.setUrlTitle(urlTitle);
		}

		productsImpl.resetOriginalValues();

		return productsImpl;
	}

	public String uuid;
	public long productId;
	public long companyId;
	public long groupId;
	public long userId;
	public String userName;
	public long createDate;
	public long modifiedDate;
	public String productName;
	public String productDescription;
	public String urlTitle;
}