/**
 *     Copyright (C) 2009-2012  Jack A. Rider All rights reserved.
 * 
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 */
 
 package org.xmlportletfactory.xmlpf.assetsintegration.service.impl;

import java.util.List;

import org.xmlportletfactory.xmlpf.assetsintegration.NoSuchProductsException;
import org.xmlportletfactory.xmlpf.assetsintegration.model.Products;
import org.xmlportletfactory.xmlpf.assetsintegration.service.base.ProductsLocalServiceBaseImpl;
import org.xmlportletfactory.xmlpf.assetsintegration.util.ProductsIndexer;
import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.ContentTypes;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLinkConstants;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.model.ResourceConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.Date;


/**
 * @author Jack A. Rider
 * @author Juan Gonzalez P.
 */
public class ProductsLocalServiceImpl extends ProductsLocalServiceBaseImpl {

	@SuppressWarnings("unchecked")
	public List<Products> getCompanyEntries(
			long companyId, int start, int end,
			OrderByComparator obc)
		throws SystemException {

		return productsPersistence.findByCompanyId(
				companyId, start, end, obc);
	}

	@SuppressWarnings("unchecked")
	public List<Products> getCompanyEntries(
			long companyId, int start, int end)
		throws SystemException {

		return productsPersistence.findByCompanyId(
				companyId, start, end);
	}

	@SuppressWarnings("unchecked")
	public int getCompanyEntriesCount(
			long companyId)
		throws SystemException {

		return productsPersistence.countByCompanyId(companyId);
	}

	@SuppressWarnings("unchecked")
	public List findAllInUser(long userId)throws SystemException {
		List<Products> list = (List<Products>) productsPersistence.findByUserId(userId);
		return list;
	}

	@SuppressWarnings("unchecked")
	public int countAllInUser(long userId)throws SystemException {
		int count = productsPersistence.countByUserId(userId);
		return count;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUser(long userId, OrderByComparator orderByComparator) throws SystemException {

		List<Products> list = (List<Products>) findAllInUser(userId, QueryUtil.ALL_POS,QueryUtil.ALL_POS, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUser(long userId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
		List<Products> list = (List<Products>) productsPersistence.findByUserId(userId, start, end, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInGroup(long groupId) throws SystemException {
		List<Products> list = (List<Products>) productsPersistence.filterFindByGroupId(groupId);
		return list;
	}

	@SuppressWarnings("unchecked")
	public int countAllInGroup(long groupId) throws SystemException {
		int count = productsPersistence.filterCountByGroupId(groupId);
		return count;
	}

	@SuppressWarnings("unchecked")
	public List findAllInGroup(long groupId, OrderByComparator orderByComparator) throws SystemException{
		List <Products> list = (List<Products>) findAllInGroup (groupId, QueryUtil.ALL_POS,QueryUtil.ALL_POS, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInGroup(long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException{
		List <Products> list = (List<Products>) productsPersistence.filterFindByGroupId(groupId, start, end, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUserAndGroup(long userId, long groupId) throws SystemException {
		List<Products> list = (List<Products>) productsPersistence.filterFindByUserIdGroupId(userId, groupId);
		return list;
	}

	@SuppressWarnings("unchecked")
	public int countAllInUserAndGroup(long userId, long groupId) throws SystemException {
		int count = productsPersistence.filterCountByUserIdGroupId(userId, groupId);
		return count;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUserAndGroup(long userId, long groupId, OrderByComparator orderByComparator) throws SystemException {

		List<Products> list = (List<Products>) findAllInUserAndGroup(groupId, userId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, orderByComparator);
		return list;
	}

	@SuppressWarnings("unchecked")
	public List findAllInUserAndGroup(long userId, long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
		List<Products> list = (List<Products>) productsPersistence.filterFindByUserIdGroupId(userId, groupId, start, end, orderByComparator);
		return list;
	}

	public Products getProductsByUrlTitle(
			long groupId, String urlTitle)
		throws PortalException, SystemException {

		Products entry = productsPersistence.fetchByG_UT(
				groupId, urlTitle);

		return entry;
	}




	public Products addProducts (Products validProducts, ServiceContext serviceContext) throws PortalException, SystemException {
	    Products retVal = _addProducts (validProducts, serviceContext);

		// Resources
		if (serviceContext.isAddGroupPermissions() ||
			serviceContext.isAddGuestPermissions()) {

			addEntryResources(
				retVal, serviceContext.isAddGroupPermissions(),
				serviceContext.isAddGuestPermissions());
		}
		else {
			addEntryResources(
				retVal, serviceContext.getGroupPermissions(),
				serviceContext.getGuestPermissions());
		}


		// Indexer

		Indexer indexer = IndexerRegistryUtil.getIndexer(Products.class);

		indexer.reindex(retVal);

		// Asset
		updateAsset(
			retVal.getUserId(), retVal, serviceContext.getAssetCategoryIds(),
			serviceContext.getAssetTagNames(),
			serviceContext.getAssetLinkEntryIds());

		return retVal;
	}

	public Products updateProducts (Products validProducts, ServiceContext serviceContext) throws PortalException, SystemException {
	
		Products entry = productsPersistence.findByPrimaryKey(validProducts.getPrimaryKey());
		validProducts.setCreateDate(entry.getCreateDate());	

		validProducts.setModifiedDate(serviceContext.getModifiedDate(null));
		validProducts.setUrlTitle(_getUniqueURLTitle(validProducts));

		Products retVal = productsPersistence.update(validProducts, false);

		// Resources

		if ((serviceContext.getGroupPermissions() != null) ||
				(serviceContext.getGuestPermissions() != null)) {

			updateEntryResources(
				retVal, serviceContext.getGroupPermissions(),
				serviceContext.getGuestPermissions());
		}

		// Indexer

		Indexer indexer = IndexerRegistryUtil.getIndexer(Products.class);

		indexer.reindex(retVal);
		// Asset

		updateAsset(
			retVal.getUserId(), retVal, serviceContext.getAssetCategoryIds(),
			serviceContext.getAssetTagNames(),
			serviceContext.getAssetLinkEntryIds());


		return retVal;
	}

	private Products _addProducts (Products validProducts, ServiceContext serviceContext) throws PortalException, SystemException {
		Products fileobj = productsPersistence.create(counterLocalService.increment(Products.class.getName()));

	     	User user = userPersistence.findByPrimaryKey(validProducts.getUserId());

	     	Date now =new Date();
	    	fileobj.setCompanyId(validProducts.getCompanyId());
	    	fileobj.setGroupId(validProducts.getGroupId());
	    	fileobj.setUserId(user.getUserId());
	    	fileobj.setUserName(user.getFullName());
	    	fileobj.setCreateDate(now);
	    	fileobj.setModifiedDate(now);

	    	fileobj.setUuid(serviceContext.getUuid());
	    	fileobj.setUrlTitle(_getUniqueURLTitle(fileobj));

	    	fileobj.setProductName(validProducts.getProductName());
	    	fileobj.setProductDescription(validProducts.getProductDescription());

	 		return productsPersistence.update(fileobj, false);
	}

	public void deleteProductsEntry (Products fileobj) throws PortalException, SystemException {

		productsPersistence.remove(fileobj.getPrimaryKey());

		// Resources

		resourceLocalService.deleteResource(
			fileobj.getCompanyId(), Products.class.getName(),
			ResourceConstants.SCOPE_INDIVIDUAL, fileobj.getPrimaryKey());



		// Indexer

		Indexer indexer = IndexerRegistryUtil.getIndexer(Products.class);

		indexer.delete(fileobj);
		// Asset

		assetEntryLocalService.deleteEntry(
				Products.class.getName(), fileobj.getPrimaryKey());



	}



	public void addEntryResources(
			Products entry, boolean addGroupPermissions,
			boolean addGuestPermissions)
		throws PortalException, SystemException {

		resourceLocalService.addResources(
			entry.getCompanyId(), entry.getGroupId(), entry.getUserId(),
			Products.class.getName(), entry.getPrimaryKey(), false,
			addGroupPermissions, addGuestPermissions);
	}

	public void addEntryResources(
			Products entry, String[] groupPermissions,
			String[] guestPermissions)
		throws PortalException, SystemException {

		resourceLocalService.addModelResources(
			entry.getCompanyId(), entry.getGroupId(), entry.getUserId(),
			Products.class.getName(), entry.getPrimaryKey(), groupPermissions,
			guestPermissions);
	}

	public void addEntryResources(
			long entryId, boolean addGroupPermissions,
			boolean addGuestPermissions)
		throws PortalException, SystemException {

		Products entry = productsPersistence.findByPrimaryKey(entryId);

		addEntryResources(entry, addGroupPermissions, addGuestPermissions);
	}

	public void addEntryResources(
			long entryId, String[] groupPermissions, String[] guestPermissions)
		throws PortalException, SystemException {

		Products entry = productsPersistence.findByPrimaryKey(entryId);

		addEntryResources(entry, groupPermissions, guestPermissions);
	}

	public void updateEntryResources(
			Products entry, String[] groupPermissions,
			String[] guestPermissions)
		throws PortalException, SystemException {

		resourceLocalService.updateResources(
			entry.getCompanyId(), entry.getGroupId(),
			Products.class.getName(), entry.getPrimaryKey(), groupPermissions,
			guestPermissions);
	}
	public void updateAsset(
			long userId, Products entry, long[] assetCategoryIds,
			String[] assetTagNames, long[] assetLinkEntryIds)
		throws PortalException, SystemException {
		boolean visible = true;

		String summary = HtmlUtil.extractText(
			StringUtil.shorten(entry.getProductName(), 500));

		AssetEntry assetEntry = assetEntryLocalService.updateEntry(
			userId, entry.getGroupId(), Products.class.getName(),
			entry.getPrimaryKey(), entry.getUuid(), 0, assetCategoryIds,
			assetTagNames, visible, null, null, null, null,
			ContentTypes.TEXT_HTML, entry.getProductName(), null, summary, null, null,
			0, 0, null, false);

		assetLinkLocalService.updateLinks(
			userId, assetEntry.getEntryId(), assetLinkEntryIds,
			AssetLinkConstants.TYPE_RELATED);
	}

	private String _getUniqueURLTitle(Products entry) throws SystemException {
		String urlTitle = _createUrlTitle(entry.getPrimaryKey(), entry.getProductName());

		long entryId = entry.getPrimaryKey();

		for (int i = 1;; i++) {
			Products tmpEntry = productsPersistence.fetchByG_UT(
				entry.getGroupId(), urlTitle);

			if ((tmpEntry == null) || (entryId == tmpEntry.getPrimaryKey())) {
				break;
			}
			else {
				String suffix = StringPool.DASH + i;

				String prefix = urlTitle;

				if (urlTitle.length() > suffix.length()) {
					prefix = urlTitle.substring(
						0, urlTitle.length() - suffix.length());
				}

				urlTitle = prefix + suffix;
			}
		}

		return urlTitle;
	}

	private String _createUrlTitle(long entryId, String title) {
		if (title == null) {
			return String.valueOf(entryId);
		}

		title = title.trim().toLowerCase();

		if (Validator.isNull(title) || Validator.isNumber(title)) {

			title = String.valueOf(entryId);
		}
		else {
			title = FriendlyURLNormalizerUtil.normalize(title, _URL_TITLE_REPLACE_CHARS);
		}

		return ModelHintsUtil.trimString(
			Products.class.getName(), "urlTitle", title);
	}

	private static final char[] _URL_TITLE_REPLACE_CHARS = new char[] {
		'.', '/'
	};
}
